/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIndicesResponse extends IotResponse implements
        ToCopyableBuilder<ListIndicesResponse.Builder, ListIndicesResponse> {
    private static final SdkField<List<String>> INDEX_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("indexNames")
            .getter(getter(ListIndicesResponse::indexNames))
            .setter(setter(Builder::indexNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListIndicesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_NAMES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> indexNames;

    private final String nextToken;

    private ListIndicesResponse(BuilderImpl builder) {
        super(builder);
        this.indexNames = builder.indexNames;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the IndexNames property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIndexNames() {
        return indexNames != null && !(indexNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The index names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIndexNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The index names.
     */
    public final List<String> indexNames() {
        return indexNames;
    }

    /**
     * <p>
     * The token used to get the next set of results, or <code>null</code> if there are no additional results.
     * </p>
     * 
     * @return The token used to get the next set of results, or <code>null</code> if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIndexNames() ? indexNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIndicesResponse)) {
            return false;
        }
        ListIndicesResponse other = (ListIndicesResponse) obj;
        return hasIndexNames() == other.hasIndexNames() && Objects.equals(indexNames(), other.indexNames())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIndicesResponse").add("IndexNames", hasIndexNames() ? indexNames() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "indexNames":
            return Optional.ofNullable(clazz.cast(indexNames()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIndicesResponse, T> g) {
        return obj -> g.apply((ListIndicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListIndicesResponse> {
        /**
         * <p>
         * The index names.
         * </p>
         * 
         * @param indexNames
         *        The index names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexNames(Collection<String> indexNames);

        /**
         * <p>
         * The index names.
         * </p>
         * 
         * @param indexNames
         *        The index names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexNames(String... indexNames);

        /**
         * <p>
         * The token used to get the next set of results, or <code>null</code> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token used to get the next set of results, or <code>null</code> if there are no additional
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<String> indexNames = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIndicesResponse model) {
            super(model);
            indexNames(model.indexNames);
            nextToken(model.nextToken);
        }

        public final Collection<String> getIndexNames() {
            if (indexNames instanceof SdkAutoConstructList) {
                return null;
            }
            return indexNames;
        }

        @Override
        public final Builder indexNames(Collection<String> indexNames) {
            this.indexNames = IndexNamesListCopier.copy(indexNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder indexNames(String... indexNames) {
            indexNames(Arrays.asList(indexNames));
            return this;
        }

        public final void setIndexNames(Collection<String> indexNames) {
            this.indexNames = IndexNamesListCopier.copy(indexNames);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListIndicesResponse build() {
            return new ListIndicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
