/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class DomainConfigurationsCopier {
    static List<DomainConfigurationSummary> copy(Collection<DomainConfigurationSummary> domainConfigurationsParam) {
        if (domainConfigurationsParam == null || domainConfigurationsParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<DomainConfigurationSummary> domainConfigurationsParamCopy = new ArrayList<>(domainConfigurationsParam);
        return Collections.unmodifiableList(domainConfigurationsParamCopy);
    }

    static List<DomainConfigurationSummary> copyFromBuilder(
            Collection<? extends DomainConfigurationSummary.Builder> domainConfigurationsParam) {
        if (domainConfigurationsParam == null || domainConfigurationsParam instanceof DefaultSdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        return copy(domainConfigurationsParam.stream().map(DomainConfigurationSummary.Builder::build).collect(toList()));
    }
}
