/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetachSecurityProfileRequest extends IotRequest implements
        ToCopyableBuilder<DetachSecurityProfileRequest.Builder, DetachSecurityProfileRequest> {
    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("securityProfileName").getter(getter(DetachSecurityProfileRequest::securityProfileName))
            .setter(setter(Builder::securityProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("securityProfileName").build()).build();

    private static final SdkField<String> SECURITY_PROFILE_TARGET_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("securityProfileTargetArn")
            .getter(getter(DetachSecurityProfileRequest::securityProfileTargetArn))
            .setter(setter(Builder::securityProfileTargetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("securityProfileTargetArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_PROFILE_NAME_FIELD,
            SECURITY_PROFILE_TARGET_ARN_FIELD));

    private final String securityProfileName;

    private final String securityProfileTargetArn;

    private DetachSecurityProfileRequest(BuilderImpl builder) {
        super(builder);
        this.securityProfileName = builder.securityProfileName;
        this.securityProfileTargetArn = builder.securityProfileTargetArn;
    }

    /**
     * <p>
     * The security profile that is detached.
     * </p>
     * 
     * @return The security profile that is detached.
     */
    public final String securityProfileName() {
        return securityProfileName;
    }

    /**
     * <p>
     * The ARN of the thing group from which the security profile is detached.
     * </p>
     * 
     * @return The ARN of the thing group from which the security profile is detached.
     */
    public final String securityProfileTargetArn() {
        return securityProfileTargetArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(securityProfileTargetArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachSecurityProfileRequest)) {
            return false;
        }
        DetachSecurityProfileRequest other = (DetachSecurityProfileRequest) obj;
        return Objects.equals(securityProfileName(), other.securityProfileName())
                && Objects.equals(securityProfileTargetArn(), other.securityProfileTargetArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetachSecurityProfileRequest").add("SecurityProfileName", securityProfileName())
                .add("SecurityProfileTargetArn", securityProfileTargetArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "securityProfileName":
            return Optional.ofNullable(clazz.cast(securityProfileName()));
        case "securityProfileTargetArn":
            return Optional.ofNullable(clazz.cast(securityProfileTargetArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetachSecurityProfileRequest, T> g) {
        return obj -> g.apply((DetachSecurityProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, DetachSecurityProfileRequest> {
        /**
         * <p>
         * The security profile that is detached.
         * </p>
         * 
         * @param securityProfileName
         *        The security profile that is detached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileName(String securityProfileName);

        /**
         * <p>
         * The ARN of the thing group from which the security profile is detached.
         * </p>
         * 
         * @param securityProfileTargetArn
         *        The ARN of the thing group from which the security profile is detached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityProfileTargetArn(String securityProfileTargetArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String securityProfileName;

        private String securityProfileTargetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachSecurityProfileRequest model) {
            super(model);
            securityProfileName(model.securityProfileName);
            securityProfileTargetArn(model.securityProfileTargetArn);
        }

        public final String getSecurityProfileName() {
            return securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        public final String getSecurityProfileTargetArn() {
            return securityProfileTargetArn;
        }

        @Override
        public final Builder securityProfileTargetArn(String securityProfileTargetArn) {
            this.securityProfileTargetArn = securityProfileTargetArn;
            return this;
        }

        public final void setSecurityProfileTargetArn(String securityProfileTargetArn) {
            this.securityProfileTargetArn = securityProfileTargetArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetachSecurityProfileRequest build() {
            return new DetachSecurityProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
