/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the actions associated with a rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Action implements SdkPojo, Serializable, ToCopyableBuilder<Action.Builder, Action> {
    private static final SdkField<DynamoDBAction> DYNAMO_DB_FIELD = SdkField.<DynamoDBAction> builder(MarshallingType.SDK_POJO)
            .memberName("dynamoDB").getter(getter(Action::dynamoDB)).setter(setter(Builder::dynamoDB))
            .constructor(DynamoDBAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamoDB").build()).build();

    private static final SdkField<DynamoDBv2Action> DYNAMO_DB_V2_FIELD = SdkField
            .<DynamoDBv2Action> builder(MarshallingType.SDK_POJO).memberName("dynamoDBv2").getter(getter(Action::dynamoDBv2))
            .setter(setter(Builder::dynamoDBv2)).constructor(DynamoDBv2Action::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamoDBv2").build()).build();

    private static final SdkField<LambdaAction> LAMBDA_FIELD = SdkField.<LambdaAction> builder(MarshallingType.SDK_POJO)
            .memberName("lambda").getter(getter(Action::lambda)).setter(setter(Builder::lambda))
            .constructor(LambdaAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambda").build()).build();

    private static final SdkField<SnsAction> SNS_FIELD = SdkField.<SnsAction> builder(MarshallingType.SDK_POJO).memberName("sns")
            .getter(getter(Action::sns)).setter(setter(Builder::sns)).constructor(SnsAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sns").build()).build();

    private static final SdkField<SqsAction> SQS_FIELD = SdkField.<SqsAction> builder(MarshallingType.SDK_POJO).memberName("sqs")
            .getter(getter(Action::sqs)).setter(setter(Builder::sqs)).constructor(SqsAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqs").build()).build();

    private static final SdkField<KinesisAction> KINESIS_FIELD = SdkField.<KinesisAction> builder(MarshallingType.SDK_POJO)
            .memberName("kinesis").getter(getter(Action::kinesis)).setter(setter(Builder::kinesis))
            .constructor(KinesisAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kinesis").build()).build();

    private static final SdkField<RepublishAction> REPUBLISH_FIELD = SdkField.<RepublishAction> builder(MarshallingType.SDK_POJO)
            .memberName("republish").getter(getter(Action::republish)).setter(setter(Builder::republish))
            .constructor(RepublishAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("republish").build()).build();

    private static final SdkField<S3Action> S3_FIELD = SdkField.<S3Action> builder(MarshallingType.SDK_POJO).memberName("s3")
            .getter(getter(Action::s3)).setter(setter(Builder::s3)).constructor(S3Action::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3").build()).build();

    private static final SdkField<FirehoseAction> FIREHOSE_FIELD = SdkField.<FirehoseAction> builder(MarshallingType.SDK_POJO)
            .memberName("firehose").getter(getter(Action::firehose)).setter(setter(Builder::firehose))
            .constructor(FirehoseAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firehose").build()).build();

    private static final SdkField<CloudwatchMetricAction> CLOUDWATCH_METRIC_FIELD = SdkField
            .<CloudwatchMetricAction> builder(MarshallingType.SDK_POJO).memberName("cloudwatchMetric")
            .getter(getter(Action::cloudwatchMetric)).setter(setter(Builder::cloudwatchMetric))
            .constructor(CloudwatchMetricAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudwatchMetric").build()).build();

    private static final SdkField<CloudwatchAlarmAction> CLOUDWATCH_ALARM_FIELD = SdkField
            .<CloudwatchAlarmAction> builder(MarshallingType.SDK_POJO).memberName("cloudwatchAlarm")
            .getter(getter(Action::cloudwatchAlarm)).setter(setter(Builder::cloudwatchAlarm))
            .constructor(CloudwatchAlarmAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudwatchAlarm").build()).build();

    private static final SdkField<CloudwatchLogsAction> CLOUDWATCH_LOGS_FIELD = SdkField
            .<CloudwatchLogsAction> builder(MarshallingType.SDK_POJO).memberName("cloudwatchLogs")
            .getter(getter(Action::cloudwatchLogs)).setter(setter(Builder::cloudwatchLogs))
            .constructor(CloudwatchLogsAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudwatchLogs").build()).build();

    private static final SdkField<ElasticsearchAction> ELASTICSEARCH_FIELD = SdkField
            .<ElasticsearchAction> builder(MarshallingType.SDK_POJO).memberName("elasticsearch")
            .getter(getter(Action::elasticsearch)).setter(setter(Builder::elasticsearch))
            .constructor(ElasticsearchAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elasticsearch").build()).build();

    private static final SdkField<SalesforceAction> SALESFORCE_FIELD = SdkField
            .<SalesforceAction> builder(MarshallingType.SDK_POJO).memberName("salesforce").getter(getter(Action::salesforce))
            .setter(setter(Builder::salesforce)).constructor(SalesforceAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("salesforce").build()).build();

    private static final SdkField<IotAnalyticsAction> IOT_ANALYTICS_FIELD = SdkField
            .<IotAnalyticsAction> builder(MarshallingType.SDK_POJO).memberName("iotAnalytics")
            .getter(getter(Action::iotAnalytics)).setter(setter(Builder::iotAnalytics)).constructor(IotAnalyticsAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotAnalytics").build()).build();

    private static final SdkField<IotEventsAction> IOT_EVENTS_FIELD = SdkField
            .<IotEventsAction> builder(MarshallingType.SDK_POJO).memberName("iotEvents").getter(getter(Action::iotEvents))
            .setter(setter(Builder::iotEvents)).constructor(IotEventsAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotEvents").build()).build();

    private static final SdkField<IotSiteWiseAction> IOT_SITE_WISE_FIELD = SdkField
            .<IotSiteWiseAction> builder(MarshallingType.SDK_POJO).memberName("iotSiteWise").getter(getter(Action::iotSiteWise))
            .setter(setter(Builder::iotSiteWise)).constructor(IotSiteWiseAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotSiteWise").build()).build();

    private static final SdkField<StepFunctionsAction> STEP_FUNCTIONS_FIELD = SdkField
            .<StepFunctionsAction> builder(MarshallingType.SDK_POJO).memberName("stepFunctions")
            .getter(getter(Action::stepFunctions)).setter(setter(Builder::stepFunctions))
            .constructor(StepFunctionsAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepFunctions").build()).build();

    private static final SdkField<TimestreamAction> TIMESTREAM_FIELD = SdkField
            .<TimestreamAction> builder(MarshallingType.SDK_POJO).memberName("timestream").getter(getter(Action::timestream))
            .setter(setter(Builder::timestream)).constructor(TimestreamAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestream").build()).build();

    private static final SdkField<HttpAction> HTTP_FIELD = SdkField.<HttpAction> builder(MarshallingType.SDK_POJO)
            .memberName("http").getter(getter(Action::http)).setter(setter(Builder::http)).constructor(HttpAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("http").build()).build();

    private static final SdkField<KafkaAction> KAFKA_FIELD = SdkField.<KafkaAction> builder(MarshallingType.SDK_POJO)
            .memberName("kafka").getter(getter(Action::kafka)).setter(setter(Builder::kafka)).constructor(KafkaAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kafka").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DYNAMO_DB_FIELD,
            DYNAMO_DB_V2_FIELD, LAMBDA_FIELD, SNS_FIELD, SQS_FIELD, KINESIS_FIELD, REPUBLISH_FIELD, S3_FIELD, FIREHOSE_FIELD,
            CLOUDWATCH_METRIC_FIELD, CLOUDWATCH_ALARM_FIELD, CLOUDWATCH_LOGS_FIELD, ELASTICSEARCH_FIELD, SALESFORCE_FIELD,
            IOT_ANALYTICS_FIELD, IOT_EVENTS_FIELD, IOT_SITE_WISE_FIELD, STEP_FUNCTIONS_FIELD, TIMESTREAM_FIELD, HTTP_FIELD,
            KAFKA_FIELD));

    private static final long serialVersionUID = 1L;

    private final DynamoDBAction dynamoDB;

    private final DynamoDBv2Action dynamoDBv2;

    private final LambdaAction lambda;

    private final SnsAction sns;

    private final SqsAction sqs;

    private final KinesisAction kinesis;

    private final RepublishAction republish;

    private final S3Action s3;

    private final FirehoseAction firehose;

    private final CloudwatchMetricAction cloudwatchMetric;

    private final CloudwatchAlarmAction cloudwatchAlarm;

    private final CloudwatchLogsAction cloudwatchLogs;

    private final ElasticsearchAction elasticsearch;

    private final SalesforceAction salesforce;

    private final IotAnalyticsAction iotAnalytics;

    private final IotEventsAction iotEvents;

    private final IotSiteWiseAction iotSiteWise;

    private final StepFunctionsAction stepFunctions;

    private final TimestreamAction timestream;

    private final HttpAction http;

    private final KafkaAction kafka;

    private Action(BuilderImpl builder) {
        this.dynamoDB = builder.dynamoDB;
        this.dynamoDBv2 = builder.dynamoDBv2;
        this.lambda = builder.lambda;
        this.sns = builder.sns;
        this.sqs = builder.sqs;
        this.kinesis = builder.kinesis;
        this.republish = builder.republish;
        this.s3 = builder.s3;
        this.firehose = builder.firehose;
        this.cloudwatchMetric = builder.cloudwatchMetric;
        this.cloudwatchAlarm = builder.cloudwatchAlarm;
        this.cloudwatchLogs = builder.cloudwatchLogs;
        this.elasticsearch = builder.elasticsearch;
        this.salesforce = builder.salesforce;
        this.iotAnalytics = builder.iotAnalytics;
        this.iotEvents = builder.iotEvents;
        this.iotSiteWise = builder.iotSiteWise;
        this.stepFunctions = builder.stepFunctions;
        this.timestream = builder.timestream;
        this.http = builder.http;
        this.kafka = builder.kafka;
    }

    /**
     * <p>
     * Write to a DynamoDB table.
     * </p>
     * 
     * @return Write to a DynamoDB table.
     */
    public final DynamoDBAction dynamoDB() {
        return dynamoDB;
    }

    /**
     * <p>
     * Write to a DynamoDB table. This is a new version of the DynamoDB action. It allows you to write each attribute in
     * an MQTT message payload into a separate DynamoDB column.
     * </p>
     * 
     * @return Write to a DynamoDB table. This is a new version of the DynamoDB action. It allows you to write each
     *         attribute in an MQTT message payload into a separate DynamoDB column.
     */
    public final DynamoDBv2Action dynamoDBv2() {
        return dynamoDBv2;
    }

    /**
     * <p>
     * Invoke a Lambda function.
     * </p>
     * 
     * @return Invoke a Lambda function.
     */
    public final LambdaAction lambda() {
        return lambda;
    }

    /**
     * <p>
     * Publish to an Amazon SNS topic.
     * </p>
     * 
     * @return Publish to an Amazon SNS topic.
     */
    public final SnsAction sns() {
        return sns;
    }

    /**
     * <p>
     * Publish to an Amazon SQS queue.
     * </p>
     * 
     * @return Publish to an Amazon SQS queue.
     */
    public final SqsAction sqs() {
        return sqs;
    }

    /**
     * <p>
     * Write data to an Amazon Kinesis stream.
     * </p>
     * 
     * @return Write data to an Amazon Kinesis stream.
     */
    public final KinesisAction kinesis() {
        return kinesis;
    }

    /**
     * <p>
     * Publish to another MQTT topic.
     * </p>
     * 
     * @return Publish to another MQTT topic.
     */
    public final RepublishAction republish() {
        return republish;
    }

    /**
     * <p>
     * Write to an Amazon S3 bucket.
     * </p>
     * 
     * @return Write to an Amazon S3 bucket.
     */
    public final S3Action s3() {
        return s3;
    }

    /**
     * <p>
     * Write to an Amazon Kinesis Firehose stream.
     * </p>
     * 
     * @return Write to an Amazon Kinesis Firehose stream.
     */
    public final FirehoseAction firehose() {
        return firehose;
    }

    /**
     * <p>
     * Capture a CloudWatch metric.
     * </p>
     * 
     * @return Capture a CloudWatch metric.
     */
    public final CloudwatchMetricAction cloudwatchMetric() {
        return cloudwatchMetric;
    }

    /**
     * <p>
     * Change the state of a CloudWatch alarm.
     * </p>
     * 
     * @return Change the state of a CloudWatch alarm.
     */
    public final CloudwatchAlarmAction cloudwatchAlarm() {
        return cloudwatchAlarm;
    }

    /**
     * <p>
     * Send data to CloudWatch Logs.
     * </p>
     * 
     * @return Send data to CloudWatch Logs.
     */
    public final CloudwatchLogsAction cloudwatchLogs() {
        return cloudwatchLogs;
    }

    /**
     * <p>
     * Write data to an Amazon Elasticsearch Service domain.
     * </p>
     * 
     * @return Write data to an Amazon Elasticsearch Service domain.
     */
    public final ElasticsearchAction elasticsearch() {
        return elasticsearch;
    }

    /**
     * <p>
     * Send a message to a Salesforce IoT Cloud Input Stream.
     * </p>
     * 
     * @return Send a message to a Salesforce IoT Cloud Input Stream.
     */
    public final SalesforceAction salesforce() {
        return salesforce;
    }

    /**
     * <p>
     * Sends message data to an AWS IoT Analytics channel.
     * </p>
     * 
     * @return Sends message data to an AWS IoT Analytics channel.
     */
    public final IotAnalyticsAction iotAnalytics() {
        return iotAnalytics;
    }

    /**
     * <p>
     * Sends an input to an AWS IoT Events detector.
     * </p>
     * 
     * @return Sends an input to an AWS IoT Events detector.
     */
    public final IotEventsAction iotEvents() {
        return iotEvents;
    }

    /**
     * <p>
     * Sends data from the MQTT message that triggered the rule to AWS IoT SiteWise asset properties.
     * </p>
     * 
     * @return Sends data from the MQTT message that triggered the rule to AWS IoT SiteWise asset properties.
     */
    public final IotSiteWiseAction iotSiteWise() {
        return iotSiteWise;
    }

    /**
     * <p>
     * Starts execution of a Step Functions state machine.
     * </p>
     * 
     * @return Starts execution of a Step Functions state machine.
     */
    public final StepFunctionsAction stepFunctions() {
        return stepFunctions;
    }

    /**
     * <p>
     * The Timestream rule action writes attributes (measures) from an MQTT message into an Amazon Timestream table. For
     * more information, see the <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/timestream-rule-action.html">Timestream</a> topic
     * rule action documentation.
     * </p>
     * 
     * @return The Timestream rule action writes attributes (measures) from an MQTT message into an Amazon Timestream
     *         table. For more information, see the <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/timestream-rule-action.html">Timestream</a>
     *         topic rule action documentation.
     */
    public final TimestreamAction timestream() {
        return timestream;
    }

    /**
     * <p>
     * Send data to an HTTPS endpoint.
     * </p>
     * 
     * @return Send data to an HTTPS endpoint.
     */
    public final HttpAction http() {
        return http;
    }

    /**
     * <p>
     * Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon MSK) or self-managed Apache Kafka cluster.
     * </p>
     * 
     * @return Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon MSK) or self-managed Apache Kafka
     *         cluster.
     */
    public final KafkaAction kafka() {
        return kafka;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dynamoDB());
        hashCode = 31 * hashCode + Objects.hashCode(dynamoDBv2());
        hashCode = 31 * hashCode + Objects.hashCode(lambda());
        hashCode = 31 * hashCode + Objects.hashCode(sns());
        hashCode = 31 * hashCode + Objects.hashCode(sqs());
        hashCode = 31 * hashCode + Objects.hashCode(kinesis());
        hashCode = 31 * hashCode + Objects.hashCode(republish());
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        hashCode = 31 * hashCode + Objects.hashCode(firehose());
        hashCode = 31 * hashCode + Objects.hashCode(cloudwatchMetric());
        hashCode = 31 * hashCode + Objects.hashCode(cloudwatchAlarm());
        hashCode = 31 * hashCode + Objects.hashCode(cloudwatchLogs());
        hashCode = 31 * hashCode + Objects.hashCode(elasticsearch());
        hashCode = 31 * hashCode + Objects.hashCode(salesforce());
        hashCode = 31 * hashCode + Objects.hashCode(iotAnalytics());
        hashCode = 31 * hashCode + Objects.hashCode(iotEvents());
        hashCode = 31 * hashCode + Objects.hashCode(iotSiteWise());
        hashCode = 31 * hashCode + Objects.hashCode(stepFunctions());
        hashCode = 31 * hashCode + Objects.hashCode(timestream());
        hashCode = 31 * hashCode + Objects.hashCode(http());
        hashCode = 31 * hashCode + Objects.hashCode(kafka());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action) obj;
        return Objects.equals(dynamoDB(), other.dynamoDB()) && Objects.equals(dynamoDBv2(), other.dynamoDBv2())
                && Objects.equals(lambda(), other.lambda()) && Objects.equals(sns(), other.sns())
                && Objects.equals(sqs(), other.sqs()) && Objects.equals(kinesis(), other.kinesis())
                && Objects.equals(republish(), other.republish()) && Objects.equals(s3(), other.s3())
                && Objects.equals(firehose(), other.firehose()) && Objects.equals(cloudwatchMetric(), other.cloudwatchMetric())
                && Objects.equals(cloudwatchAlarm(), other.cloudwatchAlarm())
                && Objects.equals(cloudwatchLogs(), other.cloudwatchLogs())
                && Objects.equals(elasticsearch(), other.elasticsearch()) && Objects.equals(salesforce(), other.salesforce())
                && Objects.equals(iotAnalytics(), other.iotAnalytics()) && Objects.equals(iotEvents(), other.iotEvents())
                && Objects.equals(iotSiteWise(), other.iotSiteWise()) && Objects.equals(stepFunctions(), other.stepFunctions())
                && Objects.equals(timestream(), other.timestream()) && Objects.equals(http(), other.http())
                && Objects.equals(kafka(), other.kafka());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Action").add("DynamoDB", dynamoDB()).add("DynamoDBv2", dynamoDBv2()).add("Lambda", lambda())
                .add("Sns", sns()).add("Sqs", sqs()).add("Kinesis", kinesis()).add("Republish", republish()).add("S3", s3())
                .add("Firehose", firehose()).add("CloudwatchMetric", cloudwatchMetric())
                .add("CloudwatchAlarm", cloudwatchAlarm()).add("CloudwatchLogs", cloudwatchLogs())
                .add("Elasticsearch", elasticsearch()).add("Salesforce", salesforce()).add("IotAnalytics", iotAnalytics())
                .add("IotEvents", iotEvents()).add("IotSiteWise", iotSiteWise()).add("StepFunctions", stepFunctions())
                .add("Timestream", timestream()).add("Http", http()).add("Kafka", kafka()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dynamoDB":
            return Optional.ofNullable(clazz.cast(dynamoDB()));
        case "dynamoDBv2":
            return Optional.ofNullable(clazz.cast(dynamoDBv2()));
        case "lambda":
            return Optional.ofNullable(clazz.cast(lambda()));
        case "sns":
            return Optional.ofNullable(clazz.cast(sns()));
        case "sqs":
            return Optional.ofNullable(clazz.cast(sqs()));
        case "kinesis":
            return Optional.ofNullable(clazz.cast(kinesis()));
        case "republish":
            return Optional.ofNullable(clazz.cast(republish()));
        case "s3":
            return Optional.ofNullable(clazz.cast(s3()));
        case "firehose":
            return Optional.ofNullable(clazz.cast(firehose()));
        case "cloudwatchMetric":
            return Optional.ofNullable(clazz.cast(cloudwatchMetric()));
        case "cloudwatchAlarm":
            return Optional.ofNullable(clazz.cast(cloudwatchAlarm()));
        case "cloudwatchLogs":
            return Optional.ofNullable(clazz.cast(cloudwatchLogs()));
        case "elasticsearch":
            return Optional.ofNullable(clazz.cast(elasticsearch()));
        case "salesforce":
            return Optional.ofNullable(clazz.cast(salesforce()));
        case "iotAnalytics":
            return Optional.ofNullable(clazz.cast(iotAnalytics()));
        case "iotEvents":
            return Optional.ofNullable(clazz.cast(iotEvents()));
        case "iotSiteWise":
            return Optional.ofNullable(clazz.cast(iotSiteWise()));
        case "stepFunctions":
            return Optional.ofNullable(clazz.cast(stepFunctions()));
        case "timestream":
            return Optional.ofNullable(clazz.cast(timestream()));
        case "http":
            return Optional.ofNullable(clazz.cast(http()));
        case "kafka":
            return Optional.ofNullable(clazz.cast(kafka()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Action> {
        /**
         * <p>
         * Write to a DynamoDB table.
         * </p>
         * 
         * @param dynamoDB
         *        Write to a DynamoDB table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamoDB(DynamoDBAction dynamoDB);

        /**
         * <p>
         * Write to a DynamoDB table.
         * </p>
         * This is a convenience that creates an instance of the {@link DynamoDBAction.Builder} avoiding the need to
         * create one manually via {@link DynamoDBAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link DynamoDBAction.Builder#build()} is called immediately and its
         * result is passed to {@link #dynamoDB(DynamoDBAction)}.
         * 
         * @param dynamoDB
         *        a consumer that will call methods on {@link DynamoDBAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamoDB(DynamoDBAction)
         */
        default Builder dynamoDB(Consumer<DynamoDBAction.Builder> dynamoDB) {
            return dynamoDB(DynamoDBAction.builder().applyMutation(dynamoDB).build());
        }

        /**
         * <p>
         * Write to a DynamoDB table. This is a new version of the DynamoDB action. It allows you to write each
         * attribute in an MQTT message payload into a separate DynamoDB column.
         * </p>
         * 
         * @param dynamoDBv2
         *        Write to a DynamoDB table. This is a new version of the DynamoDB action. It allows you to write each
         *        attribute in an MQTT message payload into a separate DynamoDB column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dynamoDBv2(DynamoDBv2Action dynamoDBv2);

        /**
         * <p>
         * Write to a DynamoDB table. This is a new version of the DynamoDB action. It allows you to write each
         * attribute in an MQTT message payload into a separate DynamoDB column.
         * </p>
         * This is a convenience that creates an instance of the {@link DynamoDBv2Action.Builder} avoiding the need to
         * create one manually via {@link DynamoDBv2Action#builder()}.
         *
         * When the {@link Consumer} completes, {@link DynamoDBv2Action.Builder#build()} is called immediately and its
         * result is passed to {@link #dynamoDBv2(DynamoDBv2Action)}.
         * 
         * @param dynamoDBv2
         *        a consumer that will call methods on {@link DynamoDBv2Action.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dynamoDBv2(DynamoDBv2Action)
         */
        default Builder dynamoDBv2(Consumer<DynamoDBv2Action.Builder> dynamoDBv2) {
            return dynamoDBv2(DynamoDBv2Action.builder().applyMutation(dynamoDBv2).build());
        }

        /**
         * <p>
         * Invoke a Lambda function.
         * </p>
         * 
         * @param lambda
         *        Invoke a Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambda(LambdaAction lambda);

        /**
         * <p>
         * Invoke a Lambda function.
         * </p>
         * This is a convenience that creates an instance of the {@link LambdaAction.Builder} avoiding the need to
         * create one manually via {@link LambdaAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaAction.Builder#build()} is called immediately and its
         * result is passed to {@link #lambda(LambdaAction)}.
         * 
         * @param lambda
         *        a consumer that will call methods on {@link LambdaAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambda(LambdaAction)
         */
        default Builder lambda(Consumer<LambdaAction.Builder> lambda) {
            return lambda(LambdaAction.builder().applyMutation(lambda).build());
        }

        /**
         * <p>
         * Publish to an Amazon SNS topic.
         * </p>
         * 
         * @param sns
         *        Publish to an Amazon SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sns(SnsAction sns);

        /**
         * <p>
         * Publish to an Amazon SNS topic.
         * </p>
         * This is a convenience that creates an instance of the {@link SnsAction.Builder} avoiding the need to create
         * one manually via {@link SnsAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link SnsAction.Builder#build()} is called immediately and its result
         * is passed to {@link #sns(SnsAction)}.
         * 
         * @param sns
         *        a consumer that will call methods on {@link SnsAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sns(SnsAction)
         */
        default Builder sns(Consumer<SnsAction.Builder> sns) {
            return sns(SnsAction.builder().applyMutation(sns).build());
        }

        /**
         * <p>
         * Publish to an Amazon SQS queue.
         * </p>
         * 
         * @param sqs
         *        Publish to an Amazon SQS queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqs(SqsAction sqs);

        /**
         * <p>
         * Publish to an Amazon SQS queue.
         * </p>
         * This is a convenience that creates an instance of the {@link SqsAction.Builder} avoiding the need to create
         * one manually via {@link SqsAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link SqsAction.Builder#build()} is called immediately and its result
         * is passed to {@link #sqs(SqsAction)}.
         * 
         * @param sqs
         *        a consumer that will call methods on {@link SqsAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqs(SqsAction)
         */
        default Builder sqs(Consumer<SqsAction.Builder> sqs) {
            return sqs(SqsAction.builder().applyMutation(sqs).build());
        }

        /**
         * <p>
         * Write data to an Amazon Kinesis stream.
         * </p>
         * 
         * @param kinesis
         *        Write data to an Amazon Kinesis stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesis(KinesisAction kinesis);

        /**
         * <p>
         * Write data to an Amazon Kinesis stream.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisAction.Builder} avoiding the need to
         * create one manually via {@link KinesisAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisAction.Builder#build()} is called immediately and its
         * result is passed to {@link #kinesis(KinesisAction)}.
         * 
         * @param kinesis
         *        a consumer that will call methods on {@link KinesisAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesis(KinesisAction)
         */
        default Builder kinesis(Consumer<KinesisAction.Builder> kinesis) {
            return kinesis(KinesisAction.builder().applyMutation(kinesis).build());
        }

        /**
         * <p>
         * Publish to another MQTT topic.
         * </p>
         * 
         * @param republish
         *        Publish to another MQTT topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder republish(RepublishAction republish);

        /**
         * <p>
         * Publish to another MQTT topic.
         * </p>
         * This is a convenience that creates an instance of the {@link RepublishAction.Builder} avoiding the need to
         * create one manually via {@link RepublishAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link RepublishAction.Builder#build()} is called immediately and its
         * result is passed to {@link #republish(RepublishAction)}.
         * 
         * @param republish
         *        a consumer that will call methods on {@link RepublishAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #republish(RepublishAction)
         */
        default Builder republish(Consumer<RepublishAction.Builder> republish) {
            return republish(RepublishAction.builder().applyMutation(republish).build());
        }

        /**
         * <p>
         * Write to an Amazon S3 bucket.
         * </p>
         * 
         * @param s3
         *        Write to an Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(S3Action s3);

        /**
         * <p>
         * Write to an Amazon S3 bucket.
         * </p>
         * This is a convenience that creates an instance of the {@link S3Action.Builder} avoiding the need to create
         * one manually via {@link S3Action#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3Action.Builder#build()} is called immediately and its result is
         * passed to {@link #s3(S3Action)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link S3Action.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(S3Action)
         */
        default Builder s3(Consumer<S3Action.Builder> s3) {
            return s3(S3Action.builder().applyMutation(s3).build());
        }

        /**
         * <p>
         * Write to an Amazon Kinesis Firehose stream.
         * </p>
         * 
         * @param firehose
         *        Write to an Amazon Kinesis Firehose stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firehose(FirehoseAction firehose);

        /**
         * <p>
         * Write to an Amazon Kinesis Firehose stream.
         * </p>
         * This is a convenience that creates an instance of the {@link FirehoseAction.Builder} avoiding the need to
         * create one manually via {@link FirehoseAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link FirehoseAction.Builder#build()} is called immediately and its
         * result is passed to {@link #firehose(FirehoseAction)}.
         * 
         * @param firehose
         *        a consumer that will call methods on {@link FirehoseAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #firehose(FirehoseAction)
         */
        default Builder firehose(Consumer<FirehoseAction.Builder> firehose) {
            return firehose(FirehoseAction.builder().applyMutation(firehose).build());
        }

        /**
         * <p>
         * Capture a CloudWatch metric.
         * </p>
         * 
         * @param cloudwatchMetric
         *        Capture a CloudWatch metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudwatchMetric(CloudwatchMetricAction cloudwatchMetric);

        /**
         * <p>
         * Capture a CloudWatch metric.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudwatchMetricAction.Builder} avoiding the
         * need to create one manually via {@link CloudwatchMetricAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudwatchMetricAction.Builder#build()} is called immediately and
         * its result is passed to {@link #cloudwatchMetric(CloudwatchMetricAction)}.
         * 
         * @param cloudwatchMetric
         *        a consumer that will call methods on {@link CloudwatchMetricAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudwatchMetric(CloudwatchMetricAction)
         */
        default Builder cloudwatchMetric(Consumer<CloudwatchMetricAction.Builder> cloudwatchMetric) {
            return cloudwatchMetric(CloudwatchMetricAction.builder().applyMutation(cloudwatchMetric).build());
        }

        /**
         * <p>
         * Change the state of a CloudWatch alarm.
         * </p>
         * 
         * @param cloudwatchAlarm
         *        Change the state of a CloudWatch alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudwatchAlarm(CloudwatchAlarmAction cloudwatchAlarm);

        /**
         * <p>
         * Change the state of a CloudWatch alarm.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudwatchAlarmAction.Builder} avoiding the need
         * to create one manually via {@link CloudwatchAlarmAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudwatchAlarmAction.Builder#build()} is called immediately and
         * its result is passed to {@link #cloudwatchAlarm(CloudwatchAlarmAction)}.
         * 
         * @param cloudwatchAlarm
         *        a consumer that will call methods on {@link CloudwatchAlarmAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudwatchAlarm(CloudwatchAlarmAction)
         */
        default Builder cloudwatchAlarm(Consumer<CloudwatchAlarmAction.Builder> cloudwatchAlarm) {
            return cloudwatchAlarm(CloudwatchAlarmAction.builder().applyMutation(cloudwatchAlarm).build());
        }

        /**
         * <p>
         * Send data to CloudWatch Logs.
         * </p>
         * 
         * @param cloudwatchLogs
         *        Send data to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudwatchLogs(CloudwatchLogsAction cloudwatchLogs);

        /**
         * <p>
         * Send data to CloudWatch Logs.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudwatchLogsAction.Builder} avoiding the need
         * to create one manually via {@link CloudwatchLogsAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudwatchLogsAction.Builder#build()} is called immediately and
         * its result is passed to {@link #cloudwatchLogs(CloudwatchLogsAction)}.
         * 
         * @param cloudwatchLogs
         *        a consumer that will call methods on {@link CloudwatchLogsAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudwatchLogs(CloudwatchLogsAction)
         */
        default Builder cloudwatchLogs(Consumer<CloudwatchLogsAction.Builder> cloudwatchLogs) {
            return cloudwatchLogs(CloudwatchLogsAction.builder().applyMutation(cloudwatchLogs).build());
        }

        /**
         * <p>
         * Write data to an Amazon Elasticsearch Service domain.
         * </p>
         * 
         * @param elasticsearch
         *        Write data to an Amazon Elasticsearch Service domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticsearch(ElasticsearchAction elasticsearch);

        /**
         * <p>
         * Write data to an Amazon Elasticsearch Service domain.
         * </p>
         * This is a convenience that creates an instance of the {@link ElasticsearchAction.Builder} avoiding the need
         * to create one manually via {@link ElasticsearchAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link ElasticsearchAction.Builder#build()} is called immediately and
         * its result is passed to {@link #elasticsearch(ElasticsearchAction)}.
         * 
         * @param elasticsearch
         *        a consumer that will call methods on {@link ElasticsearchAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticsearch(ElasticsearchAction)
         */
        default Builder elasticsearch(Consumer<ElasticsearchAction.Builder> elasticsearch) {
            return elasticsearch(ElasticsearchAction.builder().applyMutation(elasticsearch).build());
        }

        /**
         * <p>
         * Send a message to a Salesforce IoT Cloud Input Stream.
         * </p>
         * 
         * @param salesforce
         *        Send a message to a Salesforce IoT Cloud Input Stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder salesforce(SalesforceAction salesforce);

        /**
         * <p>
         * Send a message to a Salesforce IoT Cloud Input Stream.
         * </p>
         * This is a convenience that creates an instance of the {@link SalesforceAction.Builder} avoiding the need to
         * create one manually via {@link SalesforceAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link SalesforceAction.Builder#build()} is called immediately and its
         * result is passed to {@link #salesforce(SalesforceAction)}.
         * 
         * @param salesforce
         *        a consumer that will call methods on {@link SalesforceAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #salesforce(SalesforceAction)
         */
        default Builder salesforce(Consumer<SalesforceAction.Builder> salesforce) {
            return salesforce(SalesforceAction.builder().applyMutation(salesforce).build());
        }

        /**
         * <p>
         * Sends message data to an AWS IoT Analytics channel.
         * </p>
         * 
         * @param iotAnalytics
         *        Sends message data to an AWS IoT Analytics channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotAnalytics(IotAnalyticsAction iotAnalytics);

        /**
         * <p>
         * Sends message data to an AWS IoT Analytics channel.
         * </p>
         * This is a convenience that creates an instance of the {@link IotAnalyticsAction.Builder} avoiding the need to
         * create one manually via {@link IotAnalyticsAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link IotAnalyticsAction.Builder#build()} is called immediately and its
         * result is passed to {@link #iotAnalytics(IotAnalyticsAction)}.
         * 
         * @param iotAnalytics
         *        a consumer that will call methods on {@link IotAnalyticsAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iotAnalytics(IotAnalyticsAction)
         */
        default Builder iotAnalytics(Consumer<IotAnalyticsAction.Builder> iotAnalytics) {
            return iotAnalytics(IotAnalyticsAction.builder().applyMutation(iotAnalytics).build());
        }

        /**
         * <p>
         * Sends an input to an AWS IoT Events detector.
         * </p>
         * 
         * @param iotEvents
         *        Sends an input to an AWS IoT Events detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotEvents(IotEventsAction iotEvents);

        /**
         * <p>
         * Sends an input to an AWS IoT Events detector.
         * </p>
         * This is a convenience that creates an instance of the {@link IotEventsAction.Builder} avoiding the need to
         * create one manually via {@link IotEventsAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link IotEventsAction.Builder#build()} is called immediately and its
         * result is passed to {@link #iotEvents(IotEventsAction)}.
         * 
         * @param iotEvents
         *        a consumer that will call methods on {@link IotEventsAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iotEvents(IotEventsAction)
         */
        default Builder iotEvents(Consumer<IotEventsAction.Builder> iotEvents) {
            return iotEvents(IotEventsAction.builder().applyMutation(iotEvents).build());
        }

        /**
         * <p>
         * Sends data from the MQTT message that triggered the rule to AWS IoT SiteWise asset properties.
         * </p>
         * 
         * @param iotSiteWise
         *        Sends data from the MQTT message that triggered the rule to AWS IoT SiteWise asset properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotSiteWise(IotSiteWiseAction iotSiteWise);

        /**
         * <p>
         * Sends data from the MQTT message that triggered the rule to AWS IoT SiteWise asset properties.
         * </p>
         * This is a convenience that creates an instance of the {@link IotSiteWiseAction.Builder} avoiding the need to
         * create one manually via {@link IotSiteWiseAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link IotSiteWiseAction.Builder#build()} is called immediately and its
         * result is passed to {@link #iotSiteWise(IotSiteWiseAction)}.
         * 
         * @param iotSiteWise
         *        a consumer that will call methods on {@link IotSiteWiseAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iotSiteWise(IotSiteWiseAction)
         */
        default Builder iotSiteWise(Consumer<IotSiteWiseAction.Builder> iotSiteWise) {
            return iotSiteWise(IotSiteWiseAction.builder().applyMutation(iotSiteWise).build());
        }

        /**
         * <p>
         * Starts execution of a Step Functions state machine.
         * </p>
         * 
         * @param stepFunctions
         *        Starts execution of a Step Functions state machine.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepFunctions(StepFunctionsAction stepFunctions);

        /**
         * <p>
         * Starts execution of a Step Functions state machine.
         * </p>
         * This is a convenience that creates an instance of the {@link StepFunctionsAction.Builder} avoiding the need
         * to create one manually via {@link StepFunctionsAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link StepFunctionsAction.Builder#build()} is called immediately and
         * its result is passed to {@link #stepFunctions(StepFunctionsAction)}.
         * 
         * @param stepFunctions
         *        a consumer that will call methods on {@link StepFunctionsAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepFunctions(StepFunctionsAction)
         */
        default Builder stepFunctions(Consumer<StepFunctionsAction.Builder> stepFunctions) {
            return stepFunctions(StepFunctionsAction.builder().applyMutation(stepFunctions).build());
        }

        /**
         * <p>
         * The Timestream rule action writes attributes (measures) from an MQTT message into an Amazon Timestream table.
         * For more information, see the <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/timestream-rule-action.html">Timestream</a> topic
         * rule action documentation.
         * </p>
         * 
         * @param timestream
         *        The Timestream rule action writes attributes (measures) from an MQTT message into an Amazon Timestream
         *        table. For more information, see the <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/timestream-rule-action.html"
         *        >Timestream</a> topic rule action documentation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestream(TimestreamAction timestream);

        /**
         * <p>
         * The Timestream rule action writes attributes (measures) from an MQTT message into an Amazon Timestream table.
         * For more information, see the <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/timestream-rule-action.html">Timestream</a> topic
         * rule action documentation.
         * </p>
         * This is a convenience that creates an instance of the {@link TimestreamAction.Builder} avoiding the need to
         * create one manually via {@link TimestreamAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimestreamAction.Builder#build()} is called immediately and its
         * result is passed to {@link #timestream(TimestreamAction)}.
         * 
         * @param timestream
         *        a consumer that will call methods on {@link TimestreamAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timestream(TimestreamAction)
         */
        default Builder timestream(Consumer<TimestreamAction.Builder> timestream) {
            return timestream(TimestreamAction.builder().applyMutation(timestream).build());
        }

        /**
         * <p>
         * Send data to an HTTPS endpoint.
         * </p>
         * 
         * @param http
         *        Send data to an HTTPS endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder http(HttpAction http);

        /**
         * <p>
         * Send data to an HTTPS endpoint.
         * </p>
         * This is a convenience that creates an instance of the {@link HttpAction.Builder} avoiding the need to create
         * one manually via {@link HttpAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link HttpAction.Builder#build()} is called immediately and its result
         * is passed to {@link #http(HttpAction)}.
         * 
         * @param http
         *        a consumer that will call methods on {@link HttpAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #http(HttpAction)
         */
        default Builder http(Consumer<HttpAction.Builder> http) {
            return http(HttpAction.builder().applyMutation(http).build());
        }

        /**
         * <p>
         * Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon MSK) or self-managed Apache Kafka
         * cluster.
         * </p>
         * 
         * @param kafka
         *        Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon MSK) or self-managed Apache
         *        Kafka cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kafka(KafkaAction kafka);

        /**
         * <p>
         * Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon MSK) or self-managed Apache Kafka
         * cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link KafkaAction.Builder} avoiding the need to create
         * one manually via {@link KafkaAction#builder()}.
         *
         * When the {@link Consumer} completes, {@link KafkaAction.Builder#build()} is called immediately and its result
         * is passed to {@link #kafka(KafkaAction)}.
         * 
         * @param kafka
         *        a consumer that will call methods on {@link KafkaAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kafka(KafkaAction)
         */
        default Builder kafka(Consumer<KafkaAction.Builder> kafka) {
            return kafka(KafkaAction.builder().applyMutation(kafka).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DynamoDBAction dynamoDB;

        private DynamoDBv2Action dynamoDBv2;

        private LambdaAction lambda;

        private SnsAction sns;

        private SqsAction sqs;

        private KinesisAction kinesis;

        private RepublishAction republish;

        private S3Action s3;

        private FirehoseAction firehose;

        private CloudwatchMetricAction cloudwatchMetric;

        private CloudwatchAlarmAction cloudwatchAlarm;

        private CloudwatchLogsAction cloudwatchLogs;

        private ElasticsearchAction elasticsearch;

        private SalesforceAction salesforce;

        private IotAnalyticsAction iotAnalytics;

        private IotEventsAction iotEvents;

        private IotSiteWiseAction iotSiteWise;

        private StepFunctionsAction stepFunctions;

        private TimestreamAction timestream;

        private HttpAction http;

        private KafkaAction kafka;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            dynamoDB(model.dynamoDB);
            dynamoDBv2(model.dynamoDBv2);
            lambda(model.lambda);
            sns(model.sns);
            sqs(model.sqs);
            kinesis(model.kinesis);
            republish(model.republish);
            s3(model.s3);
            firehose(model.firehose);
            cloudwatchMetric(model.cloudwatchMetric);
            cloudwatchAlarm(model.cloudwatchAlarm);
            cloudwatchLogs(model.cloudwatchLogs);
            elasticsearch(model.elasticsearch);
            salesforce(model.salesforce);
            iotAnalytics(model.iotAnalytics);
            iotEvents(model.iotEvents);
            iotSiteWise(model.iotSiteWise);
            stepFunctions(model.stepFunctions);
            timestream(model.timestream);
            http(model.http);
            kafka(model.kafka);
        }

        public final DynamoDBAction.Builder getDynamoDB() {
            return dynamoDB != null ? dynamoDB.toBuilder() : null;
        }

        @Override
        public final Builder dynamoDB(DynamoDBAction dynamoDB) {
            this.dynamoDB = dynamoDB;
            return this;
        }

        public final void setDynamoDB(DynamoDBAction.BuilderImpl dynamoDB) {
            this.dynamoDB = dynamoDB != null ? dynamoDB.build() : null;
        }

        public final DynamoDBv2Action.Builder getDynamoDBv2() {
            return dynamoDBv2 != null ? dynamoDBv2.toBuilder() : null;
        }

        @Override
        public final Builder dynamoDBv2(DynamoDBv2Action dynamoDBv2) {
            this.dynamoDBv2 = dynamoDBv2;
            return this;
        }

        public final void setDynamoDBv2(DynamoDBv2Action.BuilderImpl dynamoDBv2) {
            this.dynamoDBv2 = dynamoDBv2 != null ? dynamoDBv2.build() : null;
        }

        public final LambdaAction.Builder getLambda() {
            return lambda != null ? lambda.toBuilder() : null;
        }

        @Override
        public final Builder lambda(LambdaAction lambda) {
            this.lambda = lambda;
            return this;
        }

        public final void setLambda(LambdaAction.BuilderImpl lambda) {
            this.lambda = lambda != null ? lambda.build() : null;
        }

        public final SnsAction.Builder getSns() {
            return sns != null ? sns.toBuilder() : null;
        }

        @Override
        public final Builder sns(SnsAction sns) {
            this.sns = sns;
            return this;
        }

        public final void setSns(SnsAction.BuilderImpl sns) {
            this.sns = sns != null ? sns.build() : null;
        }

        public final SqsAction.Builder getSqs() {
            return sqs != null ? sqs.toBuilder() : null;
        }

        @Override
        public final Builder sqs(SqsAction sqs) {
            this.sqs = sqs;
            return this;
        }

        public final void setSqs(SqsAction.BuilderImpl sqs) {
            this.sqs = sqs != null ? sqs.build() : null;
        }

        public final KinesisAction.Builder getKinesis() {
            return kinesis != null ? kinesis.toBuilder() : null;
        }

        @Override
        public final Builder kinesis(KinesisAction kinesis) {
            this.kinesis = kinesis;
            return this;
        }

        public final void setKinesis(KinesisAction.BuilderImpl kinesis) {
            this.kinesis = kinesis != null ? kinesis.build() : null;
        }

        public final RepublishAction.Builder getRepublish() {
            return republish != null ? republish.toBuilder() : null;
        }

        @Override
        public final Builder republish(RepublishAction republish) {
            this.republish = republish;
            return this;
        }

        public final void setRepublish(RepublishAction.BuilderImpl republish) {
            this.republish = republish != null ? republish.build() : null;
        }

        public final S3Action.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        @Override
        public final Builder s3(S3Action s3) {
            this.s3 = s3;
            return this;
        }

        public final void setS3(S3Action.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        public final FirehoseAction.Builder getFirehose() {
            return firehose != null ? firehose.toBuilder() : null;
        }

        @Override
        public final Builder firehose(FirehoseAction firehose) {
            this.firehose = firehose;
            return this;
        }

        public final void setFirehose(FirehoseAction.BuilderImpl firehose) {
            this.firehose = firehose != null ? firehose.build() : null;
        }

        public final CloudwatchMetricAction.Builder getCloudwatchMetric() {
            return cloudwatchMetric != null ? cloudwatchMetric.toBuilder() : null;
        }

        @Override
        public final Builder cloudwatchMetric(CloudwatchMetricAction cloudwatchMetric) {
            this.cloudwatchMetric = cloudwatchMetric;
            return this;
        }

        public final void setCloudwatchMetric(CloudwatchMetricAction.BuilderImpl cloudwatchMetric) {
            this.cloudwatchMetric = cloudwatchMetric != null ? cloudwatchMetric.build() : null;
        }

        public final CloudwatchAlarmAction.Builder getCloudwatchAlarm() {
            return cloudwatchAlarm != null ? cloudwatchAlarm.toBuilder() : null;
        }

        @Override
        public final Builder cloudwatchAlarm(CloudwatchAlarmAction cloudwatchAlarm) {
            this.cloudwatchAlarm = cloudwatchAlarm;
            return this;
        }

        public final void setCloudwatchAlarm(CloudwatchAlarmAction.BuilderImpl cloudwatchAlarm) {
            this.cloudwatchAlarm = cloudwatchAlarm != null ? cloudwatchAlarm.build() : null;
        }

        public final CloudwatchLogsAction.Builder getCloudwatchLogs() {
            return cloudwatchLogs != null ? cloudwatchLogs.toBuilder() : null;
        }

        @Override
        public final Builder cloudwatchLogs(CloudwatchLogsAction cloudwatchLogs) {
            this.cloudwatchLogs = cloudwatchLogs;
            return this;
        }

        public final void setCloudwatchLogs(CloudwatchLogsAction.BuilderImpl cloudwatchLogs) {
            this.cloudwatchLogs = cloudwatchLogs != null ? cloudwatchLogs.build() : null;
        }

        public final ElasticsearchAction.Builder getElasticsearch() {
            return elasticsearch != null ? elasticsearch.toBuilder() : null;
        }

        @Override
        public final Builder elasticsearch(ElasticsearchAction elasticsearch) {
            this.elasticsearch = elasticsearch;
            return this;
        }

        public final void setElasticsearch(ElasticsearchAction.BuilderImpl elasticsearch) {
            this.elasticsearch = elasticsearch != null ? elasticsearch.build() : null;
        }

        public final SalesforceAction.Builder getSalesforce() {
            return salesforce != null ? salesforce.toBuilder() : null;
        }

        @Override
        public final Builder salesforce(SalesforceAction salesforce) {
            this.salesforce = salesforce;
            return this;
        }

        public final void setSalesforce(SalesforceAction.BuilderImpl salesforce) {
            this.salesforce = salesforce != null ? salesforce.build() : null;
        }

        public final IotAnalyticsAction.Builder getIotAnalytics() {
            return iotAnalytics != null ? iotAnalytics.toBuilder() : null;
        }

        @Override
        public final Builder iotAnalytics(IotAnalyticsAction iotAnalytics) {
            this.iotAnalytics = iotAnalytics;
            return this;
        }

        public final void setIotAnalytics(IotAnalyticsAction.BuilderImpl iotAnalytics) {
            this.iotAnalytics = iotAnalytics != null ? iotAnalytics.build() : null;
        }

        public final IotEventsAction.Builder getIotEvents() {
            return iotEvents != null ? iotEvents.toBuilder() : null;
        }

        @Override
        public final Builder iotEvents(IotEventsAction iotEvents) {
            this.iotEvents = iotEvents;
            return this;
        }

        public final void setIotEvents(IotEventsAction.BuilderImpl iotEvents) {
            this.iotEvents = iotEvents != null ? iotEvents.build() : null;
        }

        public final IotSiteWiseAction.Builder getIotSiteWise() {
            return iotSiteWise != null ? iotSiteWise.toBuilder() : null;
        }

        @Override
        public final Builder iotSiteWise(IotSiteWiseAction iotSiteWise) {
            this.iotSiteWise = iotSiteWise;
            return this;
        }

        public final void setIotSiteWise(IotSiteWiseAction.BuilderImpl iotSiteWise) {
            this.iotSiteWise = iotSiteWise != null ? iotSiteWise.build() : null;
        }

        public final StepFunctionsAction.Builder getStepFunctions() {
            return stepFunctions != null ? stepFunctions.toBuilder() : null;
        }

        @Override
        public final Builder stepFunctions(StepFunctionsAction stepFunctions) {
            this.stepFunctions = stepFunctions;
            return this;
        }

        public final void setStepFunctions(StepFunctionsAction.BuilderImpl stepFunctions) {
            this.stepFunctions = stepFunctions != null ? stepFunctions.build() : null;
        }

        public final TimestreamAction.Builder getTimestream() {
            return timestream != null ? timestream.toBuilder() : null;
        }

        @Override
        public final Builder timestream(TimestreamAction timestream) {
            this.timestream = timestream;
            return this;
        }

        public final void setTimestream(TimestreamAction.BuilderImpl timestream) {
            this.timestream = timestream != null ? timestream.build() : null;
        }

        public final HttpAction.Builder getHttp() {
            return http != null ? http.toBuilder() : null;
        }

        @Override
        public final Builder http(HttpAction http) {
            this.http = http;
            return this;
        }

        public final void setHttp(HttpAction.BuilderImpl http) {
            this.http = http != null ? http.build() : null;
        }

        public final KafkaAction.Builder getKafka() {
            return kafka != null ? kafka.toBuilder() : null;
        }

        @Override
        public final Builder kafka(KafkaAction kafka) {
            this.kafka = kafka;
            return this;
        }

        public final void setKafka(KafkaAction.BuilderImpl kafka) {
            this.kafka = kafka != null ? kafka.build() : null;
        }

        @Override
        public Action build() {
            return new Action(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
