/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.PolicyVersion;
import software.amazon.awssdk.services.iot.model.PolicyVersionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPolicyVersionsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListPolicyVersionsResponse> {
    private static final SdkField<List<PolicyVersion>> POLICY_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("policyVersions").getter(ListPolicyVersionsResponse.getter(ListPolicyVersionsResponse::policyVersions)).setter(ListPolicyVersionsResponse.setter(Builder::policyVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_VERSIONS_FIELD));
    private final List<PolicyVersion> policyVersions;

    private ListPolicyVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.policyVersions = builder.policyVersions;
    }

    public boolean hasPolicyVersions() {
        return this.policyVersions != null && !(this.policyVersions instanceof SdkAutoConstructList);
    }

    public List<PolicyVersion> policyVersions() {
        return this.policyVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyVersions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyVersionsResponse)) {
            return false;
        }
        ListPolicyVersionsResponse other = (ListPolicyVersionsResponse)((Object)obj);
        return Objects.equals(this.policyVersions(), other.policyVersions());
    }

    public String toString() {
        return ToString.builder((String)"ListPolicyVersionsResponse").add("PolicyVersions", this.policyVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyVersions": {
                return Optional.ofNullable(clazz.cast(this.policyVersions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPolicyVersionsResponse, T> g) {
        return obj -> g.apply((ListPolicyVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<PolicyVersion> policyVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyVersionsResponse model) {
            super(model);
            this.policyVersions(model.policyVersions);
        }

        public final Collection<PolicyVersion.Builder> getPolicyVersions() {
            return this.policyVersions != null ? (Collection)this.policyVersions.stream().map(PolicyVersion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policyVersions(Collection<PolicyVersion> policyVersions) {
            this.policyVersions = PolicyVersionsCopier.copy(policyVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyVersions(PolicyVersion ... policyVersions) {
            this.policyVersions(Arrays.asList(policyVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyVersions(Consumer<PolicyVersion.Builder> ... policyVersions) {
            this.policyVersions(Stream.of(policyVersions).map(c -> (PolicyVersion)((PolicyVersion.Builder)PolicyVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolicyVersions(Collection<PolicyVersion.BuilderImpl> policyVersions) {
            this.policyVersions = PolicyVersionsCopier.copyFromBuilder(policyVersions);
        }

        @Override
        public ListPolicyVersionsResponse build() {
            return new ListPolicyVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPolicyVersionsResponse> {
        public Builder policyVersions(Collection<PolicyVersion> var1);

        public Builder policyVersions(PolicyVersion ... var1);

        public Builder policyVersions(Consumer<PolicyVersion.Builder> ... var1);
    }
}

