/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IotEventsAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IotEventsAction> {
    private static final SdkField<String> INPUT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputName").getter(IotEventsAction.getter(IotEventsAction::inputName)).setter(IotEventsAction.setter(Builder::inputName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputName").build()}).build();
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("messageId").getter(IotEventsAction.getter(IotEventsAction::messageId)).setter(IotEventsAction.setter(Builder::messageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageId").build()}).build();
    private static final SdkField<Boolean> BATCH_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("batchMode").getter(IotEventsAction.getter(IotEventsAction::batchMode)).setter(IotEventsAction.setter(Builder::batchMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchMode").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(IotEventsAction.getter(IotEventsAction::roleArn)).setter(IotEventsAction.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_NAME_FIELD, MESSAGE_ID_FIELD, BATCH_MODE_FIELD, ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String inputName;
    private final String messageId;
    private final Boolean batchMode;
    private final String roleArn;

    private IotEventsAction(BuilderImpl builder) {
        this.inputName = builder.inputName;
        this.messageId = builder.messageId;
        this.batchMode = builder.batchMode;
        this.roleArn = builder.roleArn;
    }

    public final String inputName() {
        return this.inputName;
    }

    public final String messageId() {
        return this.messageId;
    }

    public final Boolean batchMode() {
        return this.batchMode;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputName());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IotEventsAction)) {
            return false;
        }
        IotEventsAction other = (IotEventsAction)obj;
        return Objects.equals(this.inputName(), other.inputName()) && Objects.equals(this.messageId(), other.messageId()) && Objects.equals(this.batchMode(), other.batchMode()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"IotEventsAction").add("InputName", (Object)this.inputName()).add("MessageId", (Object)this.messageId()).add("BatchMode", (Object)this.batchMode()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputName": {
                return Optional.ofNullable(clazz.cast(this.inputName()));
            }
            case "messageId": {
                return Optional.ofNullable(clazz.cast(this.messageId()));
            }
            case "batchMode": {
                return Optional.ofNullable(clazz.cast(this.batchMode()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IotEventsAction, T> g) {
        return obj -> g.apply((IotEventsAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputName;
        private String messageId;
        private Boolean batchMode;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IotEventsAction model) {
            this.inputName(model.inputName);
            this.messageId(model.messageId);
            this.batchMode(model.batchMode);
            this.roleArn(model.roleArn);
        }

        public final String getInputName() {
            return this.inputName;
        }

        @Override
        public final Builder inputName(String inputName) {
            this.inputName = inputName;
            return this;
        }

        public final void setInputName(String inputName) {
            this.inputName = inputName;
        }

        public final String getMessageId() {
            return this.messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public final Boolean getBatchMode() {
            return this.batchMode;
        }

        @Override
        public final Builder batchMode(Boolean batchMode) {
            this.batchMode = batchMode;
            return this;
        }

        public final void setBatchMode(Boolean batchMode) {
            this.batchMode = batchMode;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public IotEventsAction build() {
            return new IotEventsAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IotEventsAction> {
        public Builder inputName(String var1);

        public Builder messageId(String var1);

        public Builder batchMode(Boolean var1);

        public Builder roleArn(String var1);
    }
}

