/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.HttpHeadersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HttpContext
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HttpContext> {
    private static final SdkField<Map<String, String>> HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("headers").getter(HttpContext.getter(HttpContext::headers)).setter(HttpContext.setter(Builder::headers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryString").getter(HttpContext.getter(HttpContext::queryString)).setter(HttpContext.setter(Builder::queryString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADERS_FIELD, QUERY_STRING_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> headers;
    private final String queryString;

    private HttpContext(BuilderImpl builder) {
        this.headers = builder.headers;
        this.queryString = builder.queryString;
    }

    public final boolean hasHeaders() {
        return this.headers != null && !(this.headers instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> headers() {
        return this.headers;
    }

    public final String queryString() {
        return this.queryString;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeaders() ? this.headers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpContext)) {
            return false;
        }
        HttpContext other = (HttpContext)obj;
        return this.hasHeaders() == other.hasHeaders() && Objects.equals(this.headers(), other.headers()) && Objects.equals(this.queryString(), other.queryString());
    }

    public final String toString() {
        return ToString.builder((String)"HttpContext").add("Headers", this.hasHeaders() ? this.headers() : null).add("QueryString", (Object)this.queryString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "headers": {
                return Optional.ofNullable(clazz.cast(this.headers()));
            }
            case "queryString": {
                return Optional.ofNullable(clazz.cast(this.queryString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpContext, T> g) {
        return obj -> g.apply((HttpContext)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> headers = DefaultSdkAutoConstructMap.getInstance();
        private String queryString;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpContext model) {
            this.headers(model.headers);
            this.queryString(model.queryString);
        }

        public final Map<String, String> getHeaders() {
            if (this.headers instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.headers;
        }

        @Override
        public final Builder headers(Map<String, String> headers) {
            this.headers = HttpHeadersCopier.copy(headers);
            return this;
        }

        public final void setHeaders(Map<String, String> headers) {
            this.headers = HttpHeadersCopier.copy(headers);
        }

        public final String getQueryString() {
            return this.queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        public HttpContext build() {
            return new HttpContext(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HttpContext> {
        public Builder headers(Map<String, String> var1);

        public Builder queryString(String var1);
    }
}

