/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.ListPrincipalThingsRequest;
import software.amazon.awssdk.services.iot.model.ListPrincipalThingsResponse;

public class ListPrincipalThingsPublisher
implements SdkPublisher<ListPrincipalThingsResponse> {
    private final IotAsyncClient client;
    private final ListPrincipalThingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPrincipalThingsPublisher(IotAsyncClient client, ListPrincipalThingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPrincipalThingsPublisher(IotAsyncClient client, ListPrincipalThingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPrincipalThingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPrincipalThingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> things() {
        Function<ListPrincipalThingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.things() != null) {
                return response.things().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPrincipalThingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPrincipalThingsResponseFetcher
    implements AsyncPageFetcher<ListPrincipalThingsResponse> {
        private ListPrincipalThingsResponseFetcher() {
        }

        public boolean hasNextPage(ListPrincipalThingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPrincipalThingsResponse> nextPage(ListPrincipalThingsResponse previousPage) {
            if (previousPage == null) {
                return ListPrincipalThingsPublisher.this.client.listPrincipalThings(ListPrincipalThingsPublisher.this.firstRequest);
            }
            return ListPrincipalThingsPublisher.this.client.listPrincipalThings((ListPrincipalThingsRequest)((Object)ListPrincipalThingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

