/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.CustomMetricType;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCustomMetricResponse
extends IotResponse
implements ToCopyableBuilder<Builder, UpdateCustomMetricResponse> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricName").getter(UpdateCustomMetricResponse.getter(UpdateCustomMetricResponse::metricName)).setter(UpdateCustomMetricResponse.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()}).build();
    private static final SdkField<String> METRIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricArn").getter(UpdateCustomMetricResponse.getter(UpdateCustomMetricResponse::metricArn)).setter(UpdateCustomMetricResponse.setter(Builder::metricArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricArn").build()}).build();
    private static final SdkField<String> METRIC_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("metricType").getter(UpdateCustomMetricResponse.getter(UpdateCustomMetricResponse::metricTypeAsString)).setter(UpdateCustomMetricResponse.setter(Builder::metricType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricType").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(UpdateCustomMetricResponse.getter(UpdateCustomMetricResponse::displayName)).setter(UpdateCustomMetricResponse.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(UpdateCustomMetricResponse.getter(UpdateCustomMetricResponse::creationDate)).setter(UpdateCustomMetricResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedDate").getter(UpdateCustomMetricResponse.getter(UpdateCustomMetricResponse::lastModifiedDate)).setter(UpdateCustomMetricResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD, METRIC_ARN_FIELD, METRIC_TYPE_FIELD, DISPLAY_NAME_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));
    private final String metricName;
    private final String metricArn;
    private final String metricType;
    private final String displayName;
    private final Instant creationDate;
    private final Instant lastModifiedDate;

    private UpdateCustomMetricResponse(BuilderImpl builder) {
        super(builder);
        this.metricName = builder.metricName;
        this.metricArn = builder.metricArn;
        this.metricType = builder.metricType;
        this.displayName = builder.displayName;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final String metricArn() {
        return this.metricArn;
    }

    public final CustomMetricType metricType() {
        return CustomMetricType.fromValue(this.metricType);
    }

    public final String metricTypeAsString() {
        return this.metricType;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCustomMetricResponse)) {
            return false;
        }
        UpdateCustomMetricResponse other = (UpdateCustomMetricResponse)((Object)obj);
        return Objects.equals(this.metricName(), other.metricName()) && Objects.equals(this.metricArn(), other.metricArn()) && Objects.equals(this.metricTypeAsString(), other.metricTypeAsString()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCustomMetricResponse").add("MetricName", (Object)this.metricName()).add("MetricArn", (Object)this.metricArn()).add("MetricType", (Object)this.metricTypeAsString()).add("DisplayName", (Object)this.displayName()).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "metricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "metricArn": {
                return Optional.ofNullable(clazz.cast(this.metricArn()));
            }
            case "metricType": {
                return Optional.ofNullable(clazz.cast(this.metricTypeAsString()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCustomMetricResponse, T> g) {
        return obj -> g.apply((UpdateCustomMetricResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String metricName;
        private String metricArn;
        private String metricType;
        private String displayName;
        private Instant creationDate;
        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCustomMetricResponse model) {
            super(model);
            this.metricName(model.metricName);
            this.metricArn(model.metricArn);
            this.metricType(model.metricType);
            this.displayName(model.displayName);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getMetricArn() {
            return this.metricArn;
        }

        @Override
        public final Builder metricArn(String metricArn) {
            this.metricArn = metricArn;
            return this;
        }

        public final void setMetricArn(String metricArn) {
            this.metricArn = metricArn;
        }

        public final String getMetricType() {
            return this.metricType;
        }

        @Override
        public final Builder metricType(String metricType) {
            this.metricType = metricType;
            return this;
        }

        @Override
        public final Builder metricType(CustomMetricType metricType) {
            this.metricType(metricType == null ? null : metricType.toString());
            return this;
        }

        public final void setMetricType(String metricType) {
            this.metricType = metricType;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public UpdateCustomMetricResponse build() {
            return new UpdateCustomMetricResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCustomMetricResponse> {
        public Builder metricName(String var1);

        public Builder metricArn(String var1);

        public Builder metricType(String var1);

        public Builder metricType(CustomMetricType var1);

        public Builder displayName(String var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);
    }
}

