/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.AuthorizerConfig;
import software.amazon.awssdk.services.iot.model.DomainConfigurationStatus;
import software.amazon.awssdk.services.iot.model.DomainType;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.ServerCertificateSummary;
import software.amazon.awssdk.services.iot.model.ServerCertificatesCopier;
import software.amazon.awssdk.services.iot.model.ServiceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDomainConfigurationResponse
extends IotResponse
implements ToCopyableBuilder<Builder, DescribeDomainConfigurationResponse> {
    private static final SdkField<String> DOMAIN_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainConfigurationName").getter(DescribeDomainConfigurationResponse.getter(DescribeDomainConfigurationResponse::domainConfigurationName)).setter(DescribeDomainConfigurationResponse.setter(Builder::domainConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainConfigurationName").build()}).build();
    private static final SdkField<String> DOMAIN_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainConfigurationArn").getter(DescribeDomainConfigurationResponse.getter(DescribeDomainConfigurationResponse::domainConfigurationArn)).setter(DescribeDomainConfigurationResponse.setter(Builder::domainConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainConfigurationArn").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainName").getter(DescribeDomainConfigurationResponse.getter(DescribeDomainConfigurationResponse::domainName)).setter(DescribeDomainConfigurationResponse.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()}).build();
    private static final SdkField<List<ServerCertificateSummary>> SERVER_CERTIFICATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serverCertificates").getter(DescribeDomainConfigurationResponse.getter(DescribeDomainConfigurationResponse::serverCertificates)).setter(DescribeDomainConfigurationResponse.setter(Builder::serverCertificates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverCertificates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServerCertificateSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AuthorizerConfig> AUTHORIZER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authorizerConfig").getter(DescribeDomainConfigurationResponse.getter(DescribeDomainConfigurationResponse::authorizerConfig)).setter(DescribeDomainConfigurationResponse.setter(Builder::authorizerConfig)).constructor(AuthorizerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerConfig").build()}).build();
    private static final SdkField<String> DOMAIN_CONFIGURATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainConfigurationStatus").getter(DescribeDomainConfigurationResponse.getter(DescribeDomainConfigurationResponse::domainConfigurationStatusAsString)).setter(DescribeDomainConfigurationResponse.setter(Builder::domainConfigurationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainConfigurationStatus").build()}).build();
    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceType").getter(DescribeDomainConfigurationResponse.getter(DescribeDomainConfigurationResponse::serviceTypeAsString)).setter(DescribeDomainConfigurationResponse.setter(Builder::serviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceType").build()}).build();
    private static final SdkField<String> DOMAIN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainType").getter(DescribeDomainConfigurationResponse.getter(DescribeDomainConfigurationResponse::domainTypeAsString)).setter(DescribeDomainConfigurationResponse.setter(Builder::domainType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainType").build()}).build();
    private static final SdkField<Instant> LAST_STATUS_CHANGE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastStatusChangeDate").getter(DescribeDomainConfigurationResponse.getter(DescribeDomainConfigurationResponse::lastStatusChangeDate)).setter(DescribeDomainConfigurationResponse.setter(Builder::lastStatusChangeDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatusChangeDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_CONFIGURATION_NAME_FIELD, DOMAIN_CONFIGURATION_ARN_FIELD, DOMAIN_NAME_FIELD, SERVER_CERTIFICATES_FIELD, AUTHORIZER_CONFIG_FIELD, DOMAIN_CONFIGURATION_STATUS_FIELD, SERVICE_TYPE_FIELD, DOMAIN_TYPE_FIELD, LAST_STATUS_CHANGE_DATE_FIELD));
    private final String domainConfigurationName;
    private final String domainConfigurationArn;
    private final String domainName;
    private final List<ServerCertificateSummary> serverCertificates;
    private final AuthorizerConfig authorizerConfig;
    private final String domainConfigurationStatus;
    private final String serviceType;
    private final String domainType;
    private final Instant lastStatusChangeDate;

    private DescribeDomainConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.domainConfigurationName = builder.domainConfigurationName;
        this.domainConfigurationArn = builder.domainConfigurationArn;
        this.domainName = builder.domainName;
        this.serverCertificates = builder.serverCertificates;
        this.authorizerConfig = builder.authorizerConfig;
        this.domainConfigurationStatus = builder.domainConfigurationStatus;
        this.serviceType = builder.serviceType;
        this.domainType = builder.domainType;
        this.lastStatusChangeDate = builder.lastStatusChangeDate;
    }

    public String domainConfigurationName() {
        return this.domainConfigurationName;
    }

    public String domainConfigurationArn() {
        return this.domainConfigurationArn;
    }

    public String domainName() {
        return this.domainName;
    }

    public boolean hasServerCertificates() {
        return this.serverCertificates != null && !(this.serverCertificates instanceof SdkAutoConstructList);
    }

    public List<ServerCertificateSummary> serverCertificates() {
        return this.serverCertificates;
    }

    public AuthorizerConfig authorizerConfig() {
        return this.authorizerConfig;
    }

    public DomainConfigurationStatus domainConfigurationStatus() {
        return DomainConfigurationStatus.fromValue(this.domainConfigurationStatus);
    }

    public String domainConfigurationStatusAsString() {
        return this.domainConfigurationStatus;
    }

    public ServiceType serviceType() {
        return ServiceType.fromValue(this.serviceType);
    }

    public String serviceTypeAsString() {
        return this.serviceType;
    }

    public DomainType domainType() {
        return DomainType.fromValue(this.domainType);
    }

    public String domainTypeAsString() {
        return this.domainType;
    }

    public Instant lastStatusChangeDate() {
        return this.lastStatusChangeDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServerCertificates() ? this.serverCertificates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainConfigurationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStatusChangeDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainConfigurationResponse)) {
            return false;
        }
        DescribeDomainConfigurationResponse other = (DescribeDomainConfigurationResponse)((Object)obj);
        return Objects.equals(this.domainConfigurationName(), other.domainConfigurationName()) && Objects.equals(this.domainConfigurationArn(), other.domainConfigurationArn()) && Objects.equals(this.domainName(), other.domainName()) && this.hasServerCertificates() == other.hasServerCertificates() && Objects.equals(this.serverCertificates(), other.serverCertificates()) && Objects.equals(this.authorizerConfig(), other.authorizerConfig()) && Objects.equals(this.domainConfigurationStatusAsString(), other.domainConfigurationStatusAsString()) && Objects.equals(this.serviceTypeAsString(), other.serviceTypeAsString()) && Objects.equals(this.domainTypeAsString(), other.domainTypeAsString()) && Objects.equals(this.lastStatusChangeDate(), other.lastStatusChangeDate());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDomainConfigurationResponse").add("DomainConfigurationName", (Object)this.domainConfigurationName()).add("DomainConfigurationArn", (Object)this.domainConfigurationArn()).add("DomainName", (Object)this.domainName()).add("ServerCertificates", this.hasServerCertificates() ? this.serverCertificates() : null).add("AuthorizerConfig", (Object)this.authorizerConfig()).add("DomainConfigurationStatus", (Object)this.domainConfigurationStatusAsString()).add("ServiceType", (Object)this.serviceTypeAsString()).add("DomainType", (Object)this.domainTypeAsString()).add("LastStatusChangeDate", (Object)this.lastStatusChangeDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.domainConfigurationName()));
            }
            case "domainConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.domainConfigurationArn()));
            }
            case "domainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "serverCertificates": {
                return Optional.ofNullable(clazz.cast(this.serverCertificates()));
            }
            case "authorizerConfig": {
                return Optional.ofNullable(clazz.cast(this.authorizerConfig()));
            }
            case "domainConfigurationStatus": {
                return Optional.ofNullable(clazz.cast(this.domainConfigurationStatusAsString()));
            }
            case "serviceType": {
                return Optional.ofNullable(clazz.cast(this.serviceTypeAsString()));
            }
            case "domainType": {
                return Optional.ofNullable(clazz.cast(this.domainTypeAsString()));
            }
            case "lastStatusChangeDate": {
                return Optional.ofNullable(clazz.cast(this.lastStatusChangeDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDomainConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeDomainConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String domainConfigurationName;
        private String domainConfigurationArn;
        private String domainName;
        private List<ServerCertificateSummary> serverCertificates = DefaultSdkAutoConstructList.getInstance();
        private AuthorizerConfig authorizerConfig;
        private String domainConfigurationStatus;
        private String serviceType;
        private String domainType;
        private Instant lastStatusChangeDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainConfigurationResponse model) {
            super(model);
            this.domainConfigurationName(model.domainConfigurationName);
            this.domainConfigurationArn(model.domainConfigurationArn);
            this.domainName(model.domainName);
            this.serverCertificates(model.serverCertificates);
            this.authorizerConfig(model.authorizerConfig);
            this.domainConfigurationStatus(model.domainConfigurationStatus);
            this.serviceType(model.serviceType);
            this.domainType(model.domainType);
            this.lastStatusChangeDate(model.lastStatusChangeDate);
        }

        public final String getDomainConfigurationName() {
            return this.domainConfigurationName;
        }

        @Override
        public final Builder domainConfigurationName(String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
            return this;
        }

        public final void setDomainConfigurationName(String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
        }

        public final String getDomainConfigurationArn() {
            return this.domainConfigurationArn;
        }

        @Override
        public final Builder domainConfigurationArn(String domainConfigurationArn) {
            this.domainConfigurationArn = domainConfigurationArn;
            return this;
        }

        public final void setDomainConfigurationArn(String domainConfigurationArn) {
            this.domainConfigurationArn = domainConfigurationArn;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<ServerCertificateSummary.Builder> getServerCertificates() {
            if (this.serverCertificates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.serverCertificates != null ? (Collection)this.serverCertificates.stream().map(ServerCertificateSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serverCertificates(Collection<ServerCertificateSummary> serverCertificates) {
            this.serverCertificates = ServerCertificatesCopier.copy(serverCertificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverCertificates(ServerCertificateSummary ... serverCertificates) {
            this.serverCertificates(Arrays.asList(serverCertificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverCertificates(Consumer<ServerCertificateSummary.Builder> ... serverCertificates) {
            this.serverCertificates(Stream.of(serverCertificates).map(c -> (ServerCertificateSummary)((ServerCertificateSummary.Builder)ServerCertificateSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServerCertificates(Collection<ServerCertificateSummary.BuilderImpl> serverCertificates) {
            this.serverCertificates = ServerCertificatesCopier.copyFromBuilder(serverCertificates);
        }

        public final AuthorizerConfig.Builder getAuthorizerConfig() {
            return this.authorizerConfig != null ? this.authorizerConfig.toBuilder() : null;
        }

        @Override
        public final Builder authorizerConfig(AuthorizerConfig authorizerConfig) {
            this.authorizerConfig = authorizerConfig;
            return this;
        }

        public final void setAuthorizerConfig(AuthorizerConfig.BuilderImpl authorizerConfig) {
            this.authorizerConfig = authorizerConfig != null ? authorizerConfig.build() : null;
        }

        public final String getDomainConfigurationStatus() {
            return this.domainConfigurationStatus;
        }

        @Override
        public final Builder domainConfigurationStatus(String domainConfigurationStatus) {
            this.domainConfigurationStatus = domainConfigurationStatus;
            return this;
        }

        @Override
        public final Builder domainConfigurationStatus(DomainConfigurationStatus domainConfigurationStatus) {
            this.domainConfigurationStatus(domainConfigurationStatus == null ? null : domainConfigurationStatus.toString());
            return this;
        }

        public final void setDomainConfigurationStatus(String domainConfigurationStatus) {
            this.domainConfigurationStatus = domainConfigurationStatus;
        }

        public final String getServiceType() {
            return this.serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public final Builder serviceType(ServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        public final String getDomainType() {
            return this.domainType;
        }

        @Override
        public final Builder domainType(String domainType) {
            this.domainType = domainType;
            return this;
        }

        @Override
        public final Builder domainType(DomainType domainType) {
            this.domainType(domainType == null ? null : domainType.toString());
            return this;
        }

        public final void setDomainType(String domainType) {
            this.domainType = domainType;
        }

        public final Instant getLastStatusChangeDate() {
            return this.lastStatusChangeDate;
        }

        @Override
        public final Builder lastStatusChangeDate(Instant lastStatusChangeDate) {
            this.lastStatusChangeDate = lastStatusChangeDate;
            return this;
        }

        public final void setLastStatusChangeDate(Instant lastStatusChangeDate) {
            this.lastStatusChangeDate = lastStatusChangeDate;
        }

        @Override
        public DescribeDomainConfigurationResponse build() {
            return new DescribeDomainConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDomainConfigurationResponse> {
        public Builder domainConfigurationName(String var1);

        public Builder domainConfigurationArn(String var1);

        public Builder domainName(String var1);

        public Builder serverCertificates(Collection<ServerCertificateSummary> var1);

        public Builder serverCertificates(ServerCertificateSummary ... var1);

        public Builder serverCertificates(Consumer<ServerCertificateSummary.Builder> ... var1);

        public Builder authorizerConfig(AuthorizerConfig var1);

        default public Builder authorizerConfig(Consumer<AuthorizerConfig.Builder> authorizerConfig) {
            return this.authorizerConfig((AuthorizerConfig)((AuthorizerConfig.Builder)AuthorizerConfig.builder().applyMutation(authorizerConfig)).build());
        }

        public Builder domainConfigurationStatus(String var1);

        public Builder domainConfigurationStatus(DomainConfigurationStatus var1);

        public Builder serviceType(String var1);

        public Builder serviceType(ServiceType var1);

        public Builder domainType(String var1);

        public Builder domainType(DomainType var1);

        public Builder lastStatusChangeDate(Instant var1);
    }
}

