/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.ListTargetsForPolicyRequest;
import software.amazon.awssdk.services.iot.model.ListTargetsForPolicyResponse;

public class ListTargetsForPolicyPublisher
implements SdkPublisher<ListTargetsForPolicyResponse> {
    private final IotAsyncClient client;
    private final ListTargetsForPolicyRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTargetsForPolicyPublisher(IotAsyncClient client, ListTargetsForPolicyRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTargetsForPolicyPublisher(IotAsyncClient client, ListTargetsForPolicyRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTargetsForPolicyResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTargetsForPolicyResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> targets() {
        Function<ListTargetsForPolicyResponse, Iterator> getIterator = response -> {
            if (response != null && response.targets() != null) {
                return response.targets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTargetsForPolicyResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTargetsForPolicyResponseFetcher
    implements AsyncPageFetcher<ListTargetsForPolicyResponse> {
        private ListTargetsForPolicyResponseFetcher() {
        }

        public boolean hasNextPage(ListTargetsForPolicyResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<ListTargetsForPolicyResponse> nextPage(ListTargetsForPolicyResponse previousPage) {
            if (previousPage == null) {
                return ListTargetsForPolicyPublisher.this.client.listTargetsForPolicy(ListTargetsForPolicyPublisher.this.firstRequest);
            }
            return ListTargetsForPolicyPublisher.this.client.listTargetsForPolicy((ListTargetsForPolicyRequest)((Object)ListTargetsForPolicyPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

