/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FirehoseAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FirehoseAction> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(FirehoseAction.getter(FirehoseAction::roleArn)).setter(FirehoseAction.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> DELIVERY_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deliveryStreamName").getter(FirehoseAction.getter(FirehoseAction::deliveryStreamName)).setter(FirehoseAction.setter(Builder::deliveryStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deliveryStreamName").build()}).build();
    private static final SdkField<String> SEPARATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("separator").getter(FirehoseAction.getter(FirehoseAction::separator)).setter(FirehoseAction.setter(Builder::separator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("separator").build()}).build();
    private static final SdkField<Boolean> BATCH_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("batchMode").getter(FirehoseAction.getter(FirehoseAction::batchMode)).setter(FirehoseAction.setter(Builder::batchMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, DELIVERY_STREAM_NAME_FIELD, SEPARATOR_FIELD, BATCH_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String roleArn;
    private final String deliveryStreamName;
    private final String separator;
    private final Boolean batchMode;

    private FirehoseAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.deliveryStreamName = builder.deliveryStreamName;
        this.separator = builder.separator;
        this.batchMode = builder.batchMode;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String deliveryStreamName() {
        return this.deliveryStreamName;
    }

    public String separator() {
        return this.separator;
    }

    public Boolean batchMode() {
        return this.batchMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.separator());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchMode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirehoseAction)) {
            return false;
        }
        FirehoseAction other = (FirehoseAction)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.deliveryStreamName(), other.deliveryStreamName()) && Objects.equals(this.separator(), other.separator()) && Objects.equals(this.batchMode(), other.batchMode());
    }

    public String toString() {
        return ToString.builder((String)"FirehoseAction").add("RoleArn", (Object)this.roleArn()).add("DeliveryStreamName", (Object)this.deliveryStreamName()).add("Separator", (Object)this.separator()).add("BatchMode", (Object)this.batchMode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "deliveryStreamName": {
                return Optional.ofNullable(clazz.cast(this.deliveryStreamName()));
            }
            case "separator": {
                return Optional.ofNullable(clazz.cast(this.separator()));
            }
            case "batchMode": {
                return Optional.ofNullable(clazz.cast(this.batchMode()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FirehoseAction, T> g) {
        return obj -> g.apply((FirehoseAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String deliveryStreamName;
        private String separator;
        private Boolean batchMode;

        private BuilderImpl() {
        }

        private BuilderImpl(FirehoseAction model) {
            this.roleArn(model.roleArn);
            this.deliveryStreamName(model.deliveryStreamName);
            this.separator(model.separator);
            this.batchMode(model.batchMode);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final String getSeparator() {
            return this.separator;
        }

        @Override
        public final Builder separator(String separator) {
            this.separator = separator;
            return this;
        }

        public final void setSeparator(String separator) {
            this.separator = separator;
        }

        public final Boolean getBatchMode() {
            return this.batchMode;
        }

        @Override
        public final Builder batchMode(Boolean batchMode) {
            this.batchMode = batchMode;
            return this;
        }

        public final void setBatchMode(Boolean batchMode) {
            this.batchMode = batchMode;
        }

        public FirehoseAction build() {
            return new FirehoseAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FirehoseAction> {
        public Builder roleArn(String var1);

        public Builder deliveryStreamName(String var1);

        public Builder separator(String var1);

        public Builder batchMode(Boolean var1);
    }
}

