/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.CidrsCopier;
import software.amazon.awssdk.services.iot.model.PortsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricValue> {
    private static final SdkField<Long> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("count").getter(MetricValue.getter(MetricValue::count)).setter(MetricValue.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final SdkField<List<String>> CIDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cidrs").getter(MetricValue.getter(MetricValue::cidrs)).setter(MetricValue.setter(Builder::cidrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cidrs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Integer>> PORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ports").getter(MetricValue.getter(MetricValue::ports)).setter(MetricValue.setter(Builder::ports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, CIDRS_FIELD, PORTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long count;
    private final List<String> cidrs;
    private final List<Integer> ports;

    private MetricValue(BuilderImpl builder) {
        this.count = builder.count;
        this.cidrs = builder.cidrs;
        this.ports = builder.ports;
    }

    public Long count() {
        return this.count;
    }

    public boolean hasCidrs() {
        return this.cidrs != null && !(this.cidrs instanceof SdkAutoConstructList);
    }

    public List<String> cidrs() {
        return this.cidrs;
    }

    public boolean hasPorts() {
        return this.ports != null && !(this.ports instanceof SdkAutoConstructList);
    }

    public List<Integer> ports() {
        return this.ports;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrs());
        hashCode = 31 * hashCode + Objects.hashCode(this.ports());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricValue)) {
            return false;
        }
        MetricValue other = (MetricValue)obj;
        return Objects.equals(this.count(), other.count()) && Objects.equals(this.cidrs(), other.cidrs()) && Objects.equals(this.ports(), other.ports());
    }

    public String toString() {
        return ToString.builder((String)"MetricValue").add("Count", (Object)this.count()).add("Cidrs", this.cidrs()).add("Ports", this.ports()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "cidrs": {
                return Optional.ofNullable(clazz.cast(this.cidrs()));
            }
            case "ports": {
                return Optional.ofNullable(clazz.cast(this.ports()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricValue, T> g) {
        return obj -> g.apply((MetricValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long count;
        private List<String> cidrs = DefaultSdkAutoConstructList.getInstance();
        private List<Integer> ports = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricValue model) {
            this.count(model.count);
            this.cidrs(model.cidrs);
            this.ports(model.ports);
        }

        public final Long getCount() {
            return this.count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        public final Collection<String> getCidrs() {
            return this.cidrs;
        }

        @Override
        public final Builder cidrs(Collection<String> cidrs) {
            this.cidrs = CidrsCopier.copy(cidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrs(String ... cidrs) {
            this.cidrs(Arrays.asList(cidrs));
            return this;
        }

        public final void setCidrs(Collection<String> cidrs) {
            this.cidrs = CidrsCopier.copy(cidrs);
        }

        public final Collection<Integer> getPorts() {
            return this.ports;
        }

        @Override
        public final Builder ports(Collection<Integer> ports) {
            this.ports = PortsCopier.copy(ports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ports(Integer ... ports) {
            this.ports(Arrays.asList(ports));
            return this;
        }

        public final void setPorts(Collection<Integer> ports) {
            this.ports = PortsCopier.copy(ports);
        }

        public MetricValue build() {
            return new MetricValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricValue> {
        public Builder count(Long var1);

        public Builder cidrs(Collection<String> var1);

        public Builder cidrs(String ... var1);

        public Builder ports(Collection<Integer> var1);

        public Builder ports(Integer ... var1);
    }
}

