/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.JobExecutionSummaryForJob;
import software.amazon.awssdk.services.iot.model.JobExecutionSummaryForJobListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListJobExecutionsForJobResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListJobExecutionsForJobResponse> {
    private static final SdkField<List<JobExecutionSummaryForJob>> EXECUTION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("executionSummaries").getter(ListJobExecutionsForJobResponse.getter(ListJobExecutionsForJobResponse::executionSummaries)).setter(ListJobExecutionsForJobResponse.setter(Builder::executionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(JobExecutionSummaryForJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListJobExecutionsForJobResponse.getter(ListJobExecutionsForJobResponse::nextToken)).setter(ListJobExecutionsForJobResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<JobExecutionSummaryForJob> executionSummaries;
    private final String nextToken;

    private ListJobExecutionsForJobResponse(BuilderImpl builder) {
        super(builder);
        this.executionSummaries = builder.executionSummaries;
        this.nextToken = builder.nextToken;
    }

    public boolean hasExecutionSummaries() {
        return this.executionSummaries != null && !(this.executionSummaries instanceof SdkAutoConstructList);
    }

    public List<JobExecutionSummaryForJob> executionSummaries() {
        return this.executionSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExecutionSummaries() ? this.executionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobExecutionsForJobResponse)) {
            return false;
        }
        ListJobExecutionsForJobResponse other = (ListJobExecutionsForJobResponse)((Object)obj);
        return this.hasExecutionSummaries() == other.hasExecutionSummaries() && Objects.equals(this.executionSummaries(), other.executionSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListJobExecutionsForJobResponse").add("ExecutionSummaries", this.hasExecutionSummaries() ? this.executionSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionSummaries": {
                return Optional.ofNullable(clazz.cast(this.executionSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobExecutionsForJobResponse, T> g) {
        return obj -> g.apply((ListJobExecutionsForJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<JobExecutionSummaryForJob> executionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobExecutionsForJobResponse model) {
            super(model);
            this.executionSummaries(model.executionSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<JobExecutionSummaryForJob.Builder> getExecutionSummaries() {
            if (this.executionSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.executionSummaries != null ? (Collection)this.executionSummaries.stream().map(JobExecutionSummaryForJob::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder executionSummaries(Collection<JobExecutionSummaryForJob> executionSummaries) {
            this.executionSummaries = JobExecutionSummaryForJobListCopier.copy(executionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionSummaries(JobExecutionSummaryForJob ... executionSummaries) {
            this.executionSummaries(Arrays.asList(executionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder executionSummaries(Consumer<JobExecutionSummaryForJob.Builder> ... executionSummaries) {
            this.executionSummaries(Stream.of(executionSummaries).map(c -> (JobExecutionSummaryForJob)((JobExecutionSummaryForJob.Builder)JobExecutionSummaryForJob.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setExecutionSummaries(Collection<JobExecutionSummaryForJob.BuilderImpl> executionSummaries) {
            this.executionSummaries = JobExecutionSummaryForJobListCopier.copyFromBuilder(executionSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListJobExecutionsForJobResponse build() {
            return new ListJobExecutionsForJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListJobExecutionsForJobResponse> {
        public Builder executionSummaries(Collection<JobExecutionSummaryForJob> var1);

        public Builder executionSummaries(JobExecutionSummaryForJob ... var1);

        public Builder executionSummaries(Consumer<JobExecutionSummaryForJob.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

