/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.AuditFinding;
import software.amazon.awssdk.services.iot.model.ListAuditFindingsRequest;
import software.amazon.awssdk.services.iot.model.ListAuditFindingsResponse;

public class ListAuditFindingsPublisher
implements SdkPublisher<ListAuditFindingsResponse> {
    private final IotAsyncClient client;
    private final ListAuditFindingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAuditFindingsPublisher(IotAsyncClient client, ListAuditFindingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAuditFindingsPublisher(IotAsyncClient client, ListAuditFindingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAuditFindingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAuditFindingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AuditFinding> findings() {
        Function<ListAuditFindingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.findings() != null) {
                return response.findings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAuditFindingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAuditFindingsResponseFetcher
    implements AsyncPageFetcher<ListAuditFindingsResponse> {
        private ListAuditFindingsResponseFetcher() {
        }

        public boolean hasNextPage(ListAuditFindingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAuditFindingsResponse> nextPage(ListAuditFindingsResponse previousPage) {
            if (previousPage == null) {
                return ListAuditFindingsPublisher.this.client.listAuditFindings(ListAuditFindingsPublisher.this.firstRequest);
            }
            return ListAuditFindingsPublisher.this.client.listAuditFindings((ListAuditFindingsRequest)((Object)ListAuditFindingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

