/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.Configuration;
import software.amazon.awssdk.services.iot.model.EventConfigurationsCopier;
import software.amazon.awssdk.services.iot.model.EventType;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateEventConfigurationsRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateEventConfigurationsRequest> {
    private static final SdkField<Map<String, Configuration>> EVENT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("eventConfigurations").getter(UpdateEventConfigurationsRequest.getter(UpdateEventConfigurationsRequest::eventConfigurationsAsStrings)).setter(UpdateEventConfigurationsRequest.setter(Builder::eventConfigurationsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventConfigurations").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_CONFIGURATIONS_FIELD));
    private final Map<String, Configuration> eventConfigurations;

    private UpdateEventConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.eventConfigurations = builder.eventConfigurations;
    }

    public Map<EventType, Configuration> eventConfigurations() {
        return EventConfigurationsCopier.copyStringToEnum(this.eventConfigurations);
    }

    public boolean hasEventConfigurations() {
        return this.eventConfigurations != null && !(this.eventConfigurations instanceof SdkAutoConstructMap);
    }

    public Map<String, Configuration> eventConfigurationsAsStrings() {
        return this.eventConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventConfigurationsAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEventConfigurationsRequest)) {
            return false;
        }
        UpdateEventConfigurationsRequest other = (UpdateEventConfigurationsRequest)((Object)obj);
        return Objects.equals(this.eventConfigurationsAsStrings(), other.eventConfigurationsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"UpdateEventConfigurationsRequest").add("EventConfigurations", this.eventConfigurationsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventConfigurations": {
                return Optional.ofNullable(clazz.cast(this.eventConfigurationsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateEventConfigurationsRequest, T> g) {
        return obj -> g.apply((UpdateEventConfigurationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private Map<String, Configuration> eventConfigurations = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateEventConfigurationsRequest model) {
            super(model);
            this.eventConfigurationsWithStrings(model.eventConfigurations);
        }

        public final Map<String, Configuration.Builder> getEventConfigurations() {
            return this.eventConfigurations != null ? CollectionUtils.mapValues(this.eventConfigurations, Configuration::toBuilder) : null;
        }

        @Override
        public final Builder eventConfigurationsWithStrings(Map<String, Configuration> eventConfigurations) {
            this.eventConfigurations = EventConfigurationsCopier.copy(eventConfigurations);
            return this;
        }

        @Override
        public final Builder eventConfigurations(Map<EventType, Configuration> eventConfigurations) {
            this.eventConfigurations = EventConfigurationsCopier.copyEnumToString(eventConfigurations);
            return this;
        }

        public final void setEventConfigurations(Map<String, Configuration.BuilderImpl> eventConfigurations) {
            this.eventConfigurations = EventConfigurationsCopier.copyFromBuilder(eventConfigurations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateEventConfigurationsRequest build() {
            return new UpdateEventConfigurationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateEventConfigurationsRequest> {
        public Builder eventConfigurationsWithStrings(Map<String, Configuration> var1);

        public Builder eventConfigurations(Map<EventType, Configuration> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

