/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DomainType {
    ENDPOINT("ENDPOINT"),
    AWS_MANAGED("AWS_MANAGED"),
    CUSTOMER_MANAGED("CUSTOMER_MANAGED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DomainType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DomainType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DomainType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DomainType> knownValues() {
        return Stream.of(DomainType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

