/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.ResourceIdentifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuditSuppression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuditSuppression> {
    private static final SdkField<String> CHECK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AuditSuppression.getter(AuditSuppression::checkName)).setter(AuditSuppression.setter(Builder::checkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkName").build()}).build();
    private static final SdkField<ResourceIdentifier> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(AuditSuppression.getter(AuditSuppression::resourceIdentifier)).setter(AuditSuppression.setter(Builder::resourceIdentifier)).constructor(ResourceIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIdentifier").build()}).build();
    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AuditSuppression.getter(AuditSuppression::expirationDate)).setter(AuditSuppression.setter(Builder::expirationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expirationDate").build()}).build();
    private static final SdkField<Boolean> SUPPRESS_INDEFINITELY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(AuditSuppression.getter(AuditSuppression::suppressIndefinitely)).setter(AuditSuppression.setter(Builder::suppressIndefinitely)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressIndefinitely").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AuditSuppression.getter(AuditSuppression::description)).setter(AuditSuppression.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECK_NAME_FIELD, RESOURCE_IDENTIFIER_FIELD, EXPIRATION_DATE_FIELD, SUPPRESS_INDEFINITELY_FIELD, DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String checkName;
    private final ResourceIdentifier resourceIdentifier;
    private final Instant expirationDate;
    private final Boolean suppressIndefinitely;
    private final String description;

    private AuditSuppression(BuilderImpl builder) {
        this.checkName = builder.checkName;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.expirationDate = builder.expirationDate;
        this.suppressIndefinitely = builder.suppressIndefinitely;
        this.description = builder.description;
    }

    public String checkName() {
        return this.checkName;
    }

    public ResourceIdentifier resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public Instant expirationDate() {
        return this.expirationDate;
    }

    public Boolean suppressIndefinitely() {
        return this.suppressIndefinitely;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.checkName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.suppressIndefinitely());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditSuppression)) {
            return false;
        }
        AuditSuppression other = (AuditSuppression)obj;
        return Objects.equals(this.checkName(), other.checkName()) && Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && Objects.equals(this.expirationDate(), other.expirationDate()) && Objects.equals(this.suppressIndefinitely(), other.suppressIndefinitely()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"AuditSuppression").add("CheckName", (Object)this.checkName()).add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("ExpirationDate", (Object)this.expirationDate()).add("SuppressIndefinitely", (Object)this.suppressIndefinitely()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "checkName": {
                return Optional.ofNullable(clazz.cast(this.checkName()));
            }
            case "resourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "expirationDate": {
                return Optional.ofNullable(clazz.cast(this.expirationDate()));
            }
            case "suppressIndefinitely": {
                return Optional.ofNullable(clazz.cast(this.suppressIndefinitely()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuditSuppression, T> g) {
        return obj -> g.apply((AuditSuppression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String checkName;
        private ResourceIdentifier resourceIdentifier;
        private Instant expirationDate;
        private Boolean suppressIndefinitely;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditSuppression model) {
            this.checkName(model.checkName);
            this.resourceIdentifier(model.resourceIdentifier);
            this.expirationDate(model.expirationDate);
            this.suppressIndefinitely(model.suppressIndefinitely);
            this.description(model.description);
        }

        public final String getCheckName() {
            return this.checkName;
        }

        @Override
        public final Builder checkName(String checkName) {
            this.checkName = checkName;
            return this;
        }

        public final void setCheckName(String checkName) {
            this.checkName = checkName;
        }

        public final ResourceIdentifier.Builder getResourceIdentifier() {
            return this.resourceIdentifier != null ? this.resourceIdentifier.toBuilder() : null;
        }

        @Override
        public final Builder resourceIdentifier(ResourceIdentifier resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final void setResourceIdentifier(ResourceIdentifier.BuilderImpl resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier != null ? resourceIdentifier.build() : null;
        }

        public final Instant getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        public final Boolean getSuppressIndefinitely() {
            return this.suppressIndefinitely;
        }

        @Override
        public final Builder suppressIndefinitely(Boolean suppressIndefinitely) {
            this.suppressIndefinitely = suppressIndefinitely;
            return this;
        }

        public final void setSuppressIndefinitely(Boolean suppressIndefinitely) {
            this.suppressIndefinitely = suppressIndefinitely;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public AuditSuppression build() {
            return new AuditSuppression(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuditSuppression> {
        public Builder checkName(String var1);

        public Builder resourceIdentifier(ResourceIdentifier var1);

        default public Builder resourceIdentifier(Consumer<ResourceIdentifier.Builder> resourceIdentifier) {
            return this.resourceIdentifier((ResourceIdentifier)((ResourceIdentifier.Builder)ResourceIdentifier.builder().applyMutation(resourceIdentifier)).build());
        }

        public Builder expirationDate(Instant var1);

        public Builder suppressIndefinitely(Boolean var1);

        public Builder description(String var1);
    }
}

