/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AdditionalMetricsToRetainListCopier;
import software.amazon.awssdk.services.iot.model.AdditionalMetricsToRetainV2ListCopier;
import software.amazon.awssdk.services.iot.model.AlertTarget;
import software.amazon.awssdk.services.iot.model.AlertTargetType;
import software.amazon.awssdk.services.iot.model.AlertTargetsCopier;
import software.amazon.awssdk.services.iot.model.Behavior;
import software.amazon.awssdk.services.iot.model.BehaviorsCopier;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.MetricToRetain;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSecurityProfileResponse
extends IotResponse
implements ToCopyableBuilder<Builder, UpdateSecurityProfileResponse> {
    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateSecurityProfileResponse.getter(UpdateSecurityProfileResponse::securityProfileName)).setter(UpdateSecurityProfileResponse.setter(Builder::securityProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileName").build()}).build();
    private static final SdkField<String> SECURITY_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateSecurityProfileResponse.getter(UpdateSecurityProfileResponse::securityProfileArn)).setter(UpdateSecurityProfileResponse.setter(Builder::securityProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileArn").build()}).build();
    private static final SdkField<String> SECURITY_PROFILE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateSecurityProfileResponse.getter(UpdateSecurityProfileResponse::securityProfileDescription)).setter(UpdateSecurityProfileResponse.setter(Builder::securityProfileDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileDescription").build()}).build();
    private static final SdkField<List<Behavior>> BEHAVIORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateSecurityProfileResponse.getter(UpdateSecurityProfileResponse::behaviors)).setter(UpdateSecurityProfileResponse.setter(Builder::behaviors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behaviors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Behavior::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, AlertTarget>> ALERT_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(UpdateSecurityProfileResponse.getter(UpdateSecurityProfileResponse::alertTargetsAsStrings)).setter(UpdateSecurityProfileResponse.setter(Builder::alertTargetsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alertTargets").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlertTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ADDITIONAL_METRICS_TO_RETAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateSecurityProfileResponse.getter(UpdateSecurityProfileResponse::additionalMetricsToRetain)).setter(UpdateSecurityProfileResponse.setter(Builder::additionalMetricsToRetain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalMetricsToRetain").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MetricToRetain>> ADDITIONAL_METRICS_TO_RETAIN_V2_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateSecurityProfileResponse.getter(UpdateSecurityProfileResponse::additionalMetricsToRetainV2)).setter(UpdateSecurityProfileResponse.setter(Builder::additionalMetricsToRetainV2)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalMetricsToRetainV2").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricToRetain::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(UpdateSecurityProfileResponse.getter(UpdateSecurityProfileResponse::version)).setter(UpdateSecurityProfileResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(UpdateSecurityProfileResponse.getter(UpdateSecurityProfileResponse::creationDate)).setter(UpdateSecurityProfileResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(UpdateSecurityProfileResponse.getter(UpdateSecurityProfileResponse::lastModifiedDate)).setter(UpdateSecurityProfileResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_PROFILE_NAME_FIELD, SECURITY_PROFILE_ARN_FIELD, SECURITY_PROFILE_DESCRIPTION_FIELD, BEHAVIORS_FIELD, ALERT_TARGETS_FIELD, ADDITIONAL_METRICS_TO_RETAIN_FIELD, ADDITIONAL_METRICS_TO_RETAIN_V2_FIELD, VERSION_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));
    private final String securityProfileName;
    private final String securityProfileArn;
    private final String securityProfileDescription;
    private final List<Behavior> behaviors;
    private final Map<String, AlertTarget> alertTargets;
    private final List<String> additionalMetricsToRetain;
    private final List<MetricToRetain> additionalMetricsToRetainV2;
    private final Long version;
    private final Instant creationDate;
    private final Instant lastModifiedDate;

    private UpdateSecurityProfileResponse(BuilderImpl builder) {
        super(builder);
        this.securityProfileName = builder.securityProfileName;
        this.securityProfileArn = builder.securityProfileArn;
        this.securityProfileDescription = builder.securityProfileDescription;
        this.behaviors = builder.behaviors;
        this.alertTargets = builder.alertTargets;
        this.additionalMetricsToRetain = builder.additionalMetricsToRetain;
        this.additionalMetricsToRetainV2 = builder.additionalMetricsToRetainV2;
        this.version = builder.version;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public String securityProfileName() {
        return this.securityProfileName;
    }

    public String securityProfileArn() {
        return this.securityProfileArn;
    }

    public String securityProfileDescription() {
        return this.securityProfileDescription;
    }

    public boolean hasBehaviors() {
        return this.behaviors != null && !(this.behaviors instanceof SdkAutoConstructList);
    }

    public List<Behavior> behaviors() {
        return this.behaviors;
    }

    public Map<AlertTargetType, AlertTarget> alertTargets() {
        return AlertTargetsCopier.copyStringToEnum(this.alertTargets);
    }

    public boolean hasAlertTargets() {
        return this.alertTargets != null && !(this.alertTargets instanceof SdkAutoConstructMap);
    }

    public Map<String, AlertTarget> alertTargetsAsStrings() {
        return this.alertTargets;
    }

    public boolean hasAdditionalMetricsToRetain() {
        return this.additionalMetricsToRetain != null && !(this.additionalMetricsToRetain instanceof SdkAutoConstructList);
    }

    public List<String> additionalMetricsToRetain() {
        return this.additionalMetricsToRetain;
    }

    public boolean hasAdditionalMetricsToRetainV2() {
        return this.additionalMetricsToRetainV2 != null && !(this.additionalMetricsToRetainV2 instanceof SdkAutoConstructList);
    }

    public List<MetricToRetain> additionalMetricsToRetainV2() {
        return this.additionalMetricsToRetainV2;
    }

    public Long version() {
        return this.version;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.behaviors());
        hashCode = 31 * hashCode + Objects.hashCode(this.alertTargetsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalMetricsToRetain());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalMetricsToRetainV2());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityProfileResponse)) {
            return false;
        }
        UpdateSecurityProfileResponse other = (UpdateSecurityProfileResponse)((Object)obj);
        return Objects.equals(this.securityProfileName(), other.securityProfileName()) && Objects.equals(this.securityProfileArn(), other.securityProfileArn()) && Objects.equals(this.securityProfileDescription(), other.securityProfileDescription()) && Objects.equals(this.behaviors(), other.behaviors()) && Objects.equals(this.alertTargetsAsStrings(), other.alertTargetsAsStrings()) && Objects.equals(this.additionalMetricsToRetain(), other.additionalMetricsToRetain()) && Objects.equals(this.additionalMetricsToRetainV2(), other.additionalMetricsToRetainV2()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate());
    }

    public String toString() {
        return ToString.builder((String)"UpdateSecurityProfileResponse").add("SecurityProfileName", (Object)this.securityProfileName()).add("SecurityProfileArn", (Object)this.securityProfileArn()).add("SecurityProfileDescription", (Object)this.securityProfileDescription()).add("Behaviors", this.behaviors()).add("AlertTargets", this.alertTargetsAsStrings()).add("AdditionalMetricsToRetain", this.additionalMetricsToRetain()).add("AdditionalMetricsToRetainV2", this.additionalMetricsToRetainV2()).add("Version", (Object)this.version()).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "securityProfileName": {
                return Optional.ofNullable(clazz.cast(this.securityProfileName()));
            }
            case "securityProfileArn": {
                return Optional.ofNullable(clazz.cast(this.securityProfileArn()));
            }
            case "securityProfileDescription": {
                return Optional.ofNullable(clazz.cast(this.securityProfileDescription()));
            }
            case "behaviors": {
                return Optional.ofNullable(clazz.cast(this.behaviors()));
            }
            case "alertTargets": {
                return Optional.ofNullable(clazz.cast(this.alertTargetsAsStrings()));
            }
            case "additionalMetricsToRetain": {
                return Optional.ofNullable(clazz.cast(this.additionalMetricsToRetain()));
            }
            case "additionalMetricsToRetainV2": {
                return Optional.ofNullable(clazz.cast(this.additionalMetricsToRetainV2()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecurityProfileResponse, T> g) {
        return obj -> g.apply((UpdateSecurityProfileResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String securityProfileName;
        private String securityProfileArn;
        private String securityProfileDescription;
        private List<Behavior> behaviors = DefaultSdkAutoConstructList.getInstance();
        private Map<String, AlertTarget> alertTargets = DefaultSdkAutoConstructMap.getInstance();
        private List<String> additionalMetricsToRetain = DefaultSdkAutoConstructList.getInstance();
        private List<MetricToRetain> additionalMetricsToRetainV2 = DefaultSdkAutoConstructList.getInstance();
        private Long version;
        private Instant creationDate;
        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityProfileResponse model) {
            super(model);
            this.securityProfileName(model.securityProfileName);
            this.securityProfileArn(model.securityProfileArn);
            this.securityProfileDescription(model.securityProfileDescription);
            this.behaviors(model.behaviors);
            this.alertTargetsWithStrings(model.alertTargets);
            this.additionalMetricsToRetain(model.additionalMetricsToRetain);
            this.additionalMetricsToRetainV2(model.additionalMetricsToRetainV2);
            this.version(model.version);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
        }

        public final String getSecurityProfileName() {
            return this.securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        public final String getSecurityProfileArn() {
            return this.securityProfileArn;
        }

        @Override
        public final Builder securityProfileArn(String securityProfileArn) {
            this.securityProfileArn = securityProfileArn;
            return this;
        }

        public final void setSecurityProfileArn(String securityProfileArn) {
            this.securityProfileArn = securityProfileArn;
        }

        public final String getSecurityProfileDescription() {
            return this.securityProfileDescription;
        }

        @Override
        public final Builder securityProfileDescription(String securityProfileDescription) {
            this.securityProfileDescription = securityProfileDescription;
            return this;
        }

        public final void setSecurityProfileDescription(String securityProfileDescription) {
            this.securityProfileDescription = securityProfileDescription;
        }

        public final Collection<Behavior.Builder> getBehaviors() {
            return this.behaviors != null ? (Collection)this.behaviors.stream().map(Behavior::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder behaviors(Collection<Behavior> behaviors) {
            this.behaviors = BehaviorsCopier.copy(behaviors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder behaviors(Behavior ... behaviors) {
            this.behaviors(Arrays.asList(behaviors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder behaviors(Consumer<Behavior.Builder> ... behaviors) {
            this.behaviors(Stream.of(behaviors).map(c -> (Behavior)((Behavior.Builder)Behavior.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBehaviors(Collection<Behavior.BuilderImpl> behaviors) {
            this.behaviors = BehaviorsCopier.copyFromBuilder(behaviors);
        }

        public final Map<String, AlertTarget.Builder> getAlertTargets() {
            return this.alertTargets != null ? CollectionUtils.mapValues(this.alertTargets, AlertTarget::toBuilder) : null;
        }

        @Override
        public final Builder alertTargetsWithStrings(Map<String, AlertTarget> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copy(alertTargets);
            return this;
        }

        @Override
        public final Builder alertTargets(Map<AlertTargetType, AlertTarget> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copyEnumToString(alertTargets);
            return this;
        }

        public final void setAlertTargets(Map<String, AlertTarget.BuilderImpl> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copyFromBuilder(alertTargets);
        }

        public final Collection<String> getAdditionalMetricsToRetain() {
            return this.additionalMetricsToRetain;
        }

        @Override
        public final Builder additionalMetricsToRetain(Collection<String> additionalMetricsToRetain) {
            this.additionalMetricsToRetain = AdditionalMetricsToRetainListCopier.copy(additionalMetricsToRetain);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalMetricsToRetain(String ... additionalMetricsToRetain) {
            this.additionalMetricsToRetain(Arrays.asList(additionalMetricsToRetain));
            return this;
        }

        public final void setAdditionalMetricsToRetain(Collection<String> additionalMetricsToRetain) {
            this.additionalMetricsToRetain = AdditionalMetricsToRetainListCopier.copy(additionalMetricsToRetain);
        }

        public final Collection<MetricToRetain.Builder> getAdditionalMetricsToRetainV2() {
            return this.additionalMetricsToRetainV2 != null ? (Collection)this.additionalMetricsToRetainV2.stream().map(MetricToRetain::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder additionalMetricsToRetainV2(Collection<MetricToRetain> additionalMetricsToRetainV2) {
            this.additionalMetricsToRetainV2 = AdditionalMetricsToRetainV2ListCopier.copy(additionalMetricsToRetainV2);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalMetricsToRetainV2(MetricToRetain ... additionalMetricsToRetainV2) {
            this.additionalMetricsToRetainV2(Arrays.asList(additionalMetricsToRetainV2));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalMetricsToRetainV2(Consumer<MetricToRetain.Builder> ... additionalMetricsToRetainV2) {
            this.additionalMetricsToRetainV2(Stream.of(additionalMetricsToRetainV2).map(c -> (MetricToRetain)((MetricToRetain.Builder)MetricToRetain.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdditionalMetricsToRetainV2(Collection<MetricToRetain.BuilderImpl> additionalMetricsToRetainV2) {
            this.additionalMetricsToRetainV2 = AdditionalMetricsToRetainV2ListCopier.copyFromBuilder(additionalMetricsToRetainV2);
        }

        public final Long getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public UpdateSecurityProfileResponse build() {
            return new UpdateSecurityProfileResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSecurityProfileResponse> {
        public Builder securityProfileName(String var1);

        public Builder securityProfileArn(String var1);

        public Builder securityProfileDescription(String var1);

        public Builder behaviors(Collection<Behavior> var1);

        public Builder behaviors(Behavior ... var1);

        public Builder behaviors(Consumer<Behavior.Builder> ... var1);

        public Builder alertTargetsWithStrings(Map<String, AlertTarget> var1);

        public Builder alertTargets(Map<AlertTargetType, AlertTarget> var1);

        public Builder additionalMetricsToRetain(Collection<String> var1);

        public Builder additionalMetricsToRetain(String ... var1);

        public Builder additionalMetricsToRetainV2(Collection<MetricToRetain> var1);

        public Builder additionalMetricsToRetainV2(MetricToRetain ... var1);

        public Builder additionalMetricsToRetainV2(Consumer<MetricToRetain.Builder> ... var1);

        public Builder version(Long var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);
    }
}

