/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.AuditMitigationActionsTaskStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuditMitigationActionsTaskMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuditMitigationActionsTaskMetadata> {
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AuditMitigationActionsTaskMetadata.getter(AuditMitigationActionsTaskMetadata::taskId)).setter(AuditMitigationActionsTaskMetadata.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AuditMitigationActionsTaskMetadata.getter(AuditMitigationActionsTaskMetadata::startTime)).setter(AuditMitigationActionsTaskMetadata.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<String> TASK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AuditMitigationActionsTaskMetadata.getter(AuditMitigationActionsTaskMetadata::taskStatusAsString)).setter(AuditMitigationActionsTaskMetadata.setter(Builder::taskStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_ID_FIELD, START_TIME_FIELD, TASK_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String taskId;
    private final Instant startTime;
    private final String taskStatus;

    private AuditMitigationActionsTaskMetadata(BuilderImpl builder) {
        this.taskId = builder.taskId;
        this.startTime = builder.startTime;
        this.taskStatus = builder.taskStatus;
    }

    public String taskId() {
        return this.taskId;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public AuditMitigationActionsTaskStatus taskStatus() {
        return AuditMitigationActionsTaskStatus.fromValue(this.taskStatus);
    }

    public String taskStatusAsString() {
        return this.taskStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditMitigationActionsTaskMetadata)) {
            return false;
        }
        AuditMitigationActionsTaskMetadata other = (AuditMitigationActionsTaskMetadata)obj;
        return Objects.equals(this.taskId(), other.taskId()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.taskStatusAsString(), other.taskStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"AuditMitigationActionsTaskMetadata").add("TaskId", (Object)this.taskId()).add("StartTime", (Object)this.startTime()).add("TaskStatus", (Object)this.taskStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "taskStatus": {
                return Optional.ofNullable(clazz.cast(this.taskStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuditMitigationActionsTaskMetadata, T> g) {
        return obj -> g.apply((AuditMitigationActionsTaskMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskId;
        private Instant startTime;
        private String taskStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditMitigationActionsTaskMetadata model) {
            this.taskId(model.taskId);
            this.startTime(model.startTime);
            this.taskStatus(model.taskStatus);
        }

        public final String getTaskId() {
            return this.taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final String getTaskStatus() {
            return this.taskStatus;
        }

        @Override
        public final Builder taskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
            return this;
        }

        @Override
        public final Builder taskStatus(AuditMitigationActionsTaskStatus taskStatus) {
            this.taskStatus(taskStatus == null ? null : taskStatus.toString());
            return this;
        }

        public final void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        public AuditMitigationActionsTaskMetadata build() {
            return new AuditMitigationActionsTaskMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuditMitigationActionsTaskMetadata> {
        public Builder taskId(String var1);

        public Builder startTime(Instant var1);

        public Builder taskStatus(String var1);

        public Builder taskStatus(AuditMitigationActionsTaskStatus var1);
    }
}

