/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.AuditTaskMetadata;
import software.amazon.awssdk.services.iot.model.ListAuditTasksRequest;
import software.amazon.awssdk.services.iot.model.ListAuditTasksResponse;

public class ListAuditTasksPublisher
implements SdkPublisher<ListAuditTasksResponse> {
    private final IotAsyncClient client;
    private final ListAuditTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAuditTasksPublisher(IotAsyncClient client, ListAuditTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAuditTasksPublisher(IotAsyncClient client, ListAuditTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAuditTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAuditTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AuditTaskMetadata> tasks() {
        Function<ListAuditTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.tasks() != null) {
                return response.tasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAuditTasksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAuditTasksResponseFetcher
    implements AsyncPageFetcher<ListAuditTasksResponse> {
        private ListAuditTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListAuditTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAuditTasksResponse> nextPage(ListAuditTasksResponse previousPage) {
            if (previousPage == null) {
                return ListAuditTasksPublisher.this.client.listAuditTasks(ListAuditTasksPublisher.this.firstRequest);
            }
            return ListAuditTasksPublisher.this.client.listAuditTasks((ListAuditTasksRequest)((Object)ListAuditTasksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

