/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.DimensionStringValuesCopier;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDimensionRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateDimensionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDimensionRequest.getter(UpdateDimensionRequest::name)).setter(UpdateDimensionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<List<String>> STRING_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateDimensionRequest.getter(UpdateDimensionRequest::stringValues)).setter(UpdateDimensionRequest.setter(Builder::stringValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STRING_VALUES_FIELD));
    private final String name;
    private final List<String> stringValues;

    private UpdateDimensionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.stringValues = builder.stringValues;
    }

    public String name() {
        return this.name;
    }

    public boolean hasStringValues() {
        return this.stringValues != null && !(this.stringValues instanceof SdkAutoConstructList);
    }

    public List<String> stringValues() {
        return this.stringValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDimensionRequest)) {
            return false;
        }
        UpdateDimensionRequest other = (UpdateDimensionRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.stringValues(), other.stringValues());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDimensionRequest").add("Name", (Object)this.name()).add("StringValues", this.stringValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "stringValues": {
                return Optional.ofNullable(clazz.cast(this.stringValues()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDimensionRequest, T> g) {
        return obj -> g.apply((UpdateDimensionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String name;
        private List<String> stringValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDimensionRequest model) {
            super(model);
            this.name(model.name);
            this.stringValues(model.stringValues);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getStringValues() {
            return this.stringValues;
        }

        @Override
        public final Builder stringValues(Collection<String> stringValues) {
            this.stringValues = DimensionStringValuesCopier.copy(stringValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringValues(String ... stringValues) {
            this.stringValues(Arrays.asList(stringValues));
            return this;
        }

        public final void setStringValues(Collection<String> stringValues) {
            this.stringValues = DimensionStringValuesCopier.copy(stringValues);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDimensionRequest build() {
            return new UpdateDimensionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDimensionRequest> {
        public Builder name(String var1);

        public Builder stringValues(Collection<String> var1);

        public Builder stringValues(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

