/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information about a server certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServerCertificateSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ServerCertificateSummary.Builder, ServerCertificateSummary> {
    private static final SdkField<String> SERVER_CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServerCertificateSummary::serverCertificateArn)).setter(setter(Builder::serverCertificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverCertificateArn").build())
            .build();

    private static final SdkField<String> SERVER_CERTIFICATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServerCertificateSummary::serverCertificateStatusAsString))
            .setter(setter(Builder::serverCertificateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverCertificateStatus").build())
            .build();

    private static final SdkField<String> SERVER_CERTIFICATE_STATUS_DETAIL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(ServerCertificateSummary::serverCertificateStatusDetail))
            .setter(setter(Builder::serverCertificateStatusDetail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverCertificateStatusDetail")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_CERTIFICATE_ARN_FIELD,
            SERVER_CERTIFICATE_STATUS_FIELD, SERVER_CERTIFICATE_STATUS_DETAIL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serverCertificateArn;

    private final String serverCertificateStatus;

    private final String serverCertificateStatusDetail;

    private ServerCertificateSummary(BuilderImpl builder) {
        this.serverCertificateArn = builder.serverCertificateArn;
        this.serverCertificateStatus = builder.serverCertificateStatus;
        this.serverCertificateStatusDetail = builder.serverCertificateStatusDetail;
    }

    /**
     * <p>
     * The ARN of the server certificate.
     * </p>
     * 
     * @return The ARN of the server certificate.
     */
    public String serverCertificateArn() {
        return serverCertificateArn;
    }

    /**
     * <p>
     * The status of the server certificate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serverCertificateStatus} will return {@link ServerCertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #serverCertificateStatusAsString}.
     * </p>
     * 
     * @return The status of the server certificate.
     * @see ServerCertificateStatus
     */
    public ServerCertificateStatus serverCertificateStatus() {
        return ServerCertificateStatus.fromValue(serverCertificateStatus);
    }

    /**
     * <p>
     * The status of the server certificate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serverCertificateStatus} will return {@link ServerCertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #serverCertificateStatusAsString}.
     * </p>
     * 
     * @return The status of the server certificate.
     * @see ServerCertificateStatus
     */
    public String serverCertificateStatusAsString() {
        return serverCertificateStatus;
    }

    /**
     * <p>
     * Details that explain the status of the server certificate.
     * </p>
     * 
     * @return Details that explain the status of the server certificate.
     */
    public String serverCertificateStatusDetail() {
        return serverCertificateStatusDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(serverCertificateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serverCertificateStatusDetail());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerCertificateSummary)) {
            return false;
        }
        ServerCertificateSummary other = (ServerCertificateSummary) obj;
        return Objects.equals(serverCertificateArn(), other.serverCertificateArn())
                && Objects.equals(serverCertificateStatusAsString(), other.serverCertificateStatusAsString())
                && Objects.equals(serverCertificateStatusDetail(), other.serverCertificateStatusDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ServerCertificateSummary").add("ServerCertificateArn", serverCertificateArn())
                .add("ServerCertificateStatus", serverCertificateStatusAsString())
                .add("ServerCertificateStatusDetail", serverCertificateStatusDetail()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serverCertificateArn":
            return Optional.ofNullable(clazz.cast(serverCertificateArn()));
        case "serverCertificateStatus":
            return Optional.ofNullable(clazz.cast(serverCertificateStatusAsString()));
        case "serverCertificateStatusDetail":
            return Optional.ofNullable(clazz.cast(serverCertificateStatusDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServerCertificateSummary, T> g) {
        return obj -> g.apply((ServerCertificateSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServerCertificateSummary> {
        /**
         * <p>
         * The ARN of the server certificate.
         * </p>
         * 
         * @param serverCertificateArn
         *        The ARN of the server certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificateArn(String serverCertificateArn);

        /**
         * <p>
         * The status of the server certificate.
         * </p>
         * 
         * @param serverCertificateStatus
         *        The status of the server certificate.
         * @see ServerCertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerCertificateStatus
         */
        Builder serverCertificateStatus(String serverCertificateStatus);

        /**
         * <p>
         * The status of the server certificate.
         * </p>
         * 
         * @param serverCertificateStatus
         *        The status of the server certificate.
         * @see ServerCertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServerCertificateStatus
         */
        Builder serverCertificateStatus(ServerCertificateStatus serverCertificateStatus);

        /**
         * <p>
         * Details that explain the status of the server certificate.
         * </p>
         * 
         * @param serverCertificateStatusDetail
         *        Details that explain the status of the server certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificateStatusDetail(String serverCertificateStatusDetail);
    }

    static final class BuilderImpl implements Builder {
        private String serverCertificateArn;

        private String serverCertificateStatus;

        private String serverCertificateStatusDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(ServerCertificateSummary model) {
            serverCertificateArn(model.serverCertificateArn);
            serverCertificateStatus(model.serverCertificateStatus);
            serverCertificateStatusDetail(model.serverCertificateStatusDetail);
        }

        public final String getServerCertificateArn() {
            return serverCertificateArn;
        }

        @Override
        public final Builder serverCertificateArn(String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
            return this;
        }

        public final void setServerCertificateArn(String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
        }

        public final String getServerCertificateStatus() {
            return serverCertificateStatus;
        }

        @Override
        public final Builder serverCertificateStatus(String serverCertificateStatus) {
            this.serverCertificateStatus = serverCertificateStatus;
            return this;
        }

        @Override
        public final Builder serverCertificateStatus(ServerCertificateStatus serverCertificateStatus) {
            this.serverCertificateStatus(serverCertificateStatus == null ? null : serverCertificateStatus.toString());
            return this;
        }

        public final void setServerCertificateStatus(String serverCertificateStatus) {
            this.serverCertificateStatus = serverCertificateStatus;
        }

        public final String getServerCertificateStatusDetail() {
            return serverCertificateStatusDetail;
        }

        @Override
        public final Builder serverCertificateStatusDetail(String serverCertificateStatusDetail) {
            this.serverCertificateStatusDetail = serverCertificateStatusDetail;
            return this;
        }

        public final void setServerCertificateStatusDetail(String serverCertificateStatusDetail) {
            this.serverCertificateStatusDetail = serverCertificateStatusDetail;
        }

        @Override
        public ServerCertificateSummary build() {
            return new ServerCertificateSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
