/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the ListCACertificates operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCaCertificatesResponse extends IotResponse implements
        ToCopyableBuilder<ListCaCertificatesResponse.Builder, ListCaCertificatesResponse> {
    private static final SdkField<List<CACertificate>> CERTIFICATES_FIELD = SdkField
            .<List<CACertificate>> builder(MarshallingType.LIST)
            .getter(getter(ListCaCertificatesResponse::certificates))
            .setter(setter(Builder::certificates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CACertificate> builder(MarshallingType.SDK_POJO)
                                            .constructor(CACertificate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListCaCertificatesResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATES_FIELD,
            NEXT_MARKER_FIELD));

    private final List<CACertificate> certificates;

    private final String nextMarker;

    private ListCaCertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.certificates = builder.certificates;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * Returns true if the Certificates property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCertificates() {
        return certificates != null && !(certificates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The CA certificates registered in your AWS account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCertificates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The CA certificates registered in your AWS account.
     */
    public List<CACertificate> certificates() {
        return certificates;
    }

    /**
     * <p>
     * The current position within the list of CA certificates.
     * </p>
     * 
     * @return The current position within the list of CA certificates.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificates());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCaCertificatesResponse)) {
            return false;
        }
        ListCaCertificatesResponse other = (ListCaCertificatesResponse) obj;
        return Objects.equals(certificates(), other.certificates()) && Objects.equals(nextMarker(), other.nextMarker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListCaCertificatesResponse").add("Certificates", certificates()).add("NextMarker", nextMarker())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificates":
            return Optional.ofNullable(clazz.cast(certificates()));
        case "nextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCaCertificatesResponse, T> g) {
        return obj -> g.apply((ListCaCertificatesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCaCertificatesResponse> {
        /**
         * <p>
         * The CA certificates registered in your AWS account.
         * </p>
         * 
         * @param certificates
         *        The CA certificates registered in your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(Collection<CACertificate> certificates);

        /**
         * <p>
         * The CA certificates registered in your AWS account.
         * </p>
         * 
         * @param certificates
         *        The CA certificates registered in your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(CACertificate... certificates);

        /**
         * <p>
         * The CA certificates registered in your AWS account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CACertificate>.Builder} avoiding the need
         * to create one manually via {@link List<CACertificate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CACertificate>.Builder#build()} is called immediately and
         * its result is passed to {@link #certificates(List<CACertificate>)}.
         * 
         * @param certificates
         *        a consumer that will call methods on {@link List<CACertificate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificates(List<CACertificate>)
         */
        Builder certificates(Consumer<CACertificate.Builder>... certificates);

        /**
         * <p>
         * The current position within the list of CA certificates.
         * </p>
         * 
         * @param nextMarker
         *        The current position within the list of CA certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<CACertificate> certificates = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCaCertificatesResponse model) {
            super(model);
            certificates(model.certificates);
            nextMarker(model.nextMarker);
        }

        public final Collection<CACertificate.Builder> getCertificates() {
            return certificates != null ? certificates.stream().map(CACertificate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder certificates(Collection<CACertificate> certificates) {
            this.certificates = CACertificatesCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(CACertificate... certificates) {
            certificates(Arrays.asList(certificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Consumer<CACertificate.Builder>... certificates) {
            certificates(Stream.of(certificates).map(c -> CACertificate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCertificates(Collection<CACertificate.BuilderImpl> certificates) {
            this.certificates = CACertificatesCopier.copyFromBuilder(certificates);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListCaCertificatesResponse build() {
            return new ListCaCertificatesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
