/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.SecurityProfileIdentifier;
import software.amazon.awssdk.services.iot.model.SecurityProfileTarget;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityProfileTargetMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecurityProfileTargetMapping> {
    private static final SdkField<SecurityProfileIdentifier> SECURITY_PROFILE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SecurityProfileTargetMapping.getter(SecurityProfileTargetMapping::securityProfileIdentifier)).setter(SecurityProfileTargetMapping.setter(Builder::securityProfileIdentifier)).constructor(SecurityProfileIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileIdentifier").build()}).build();
    private static final SdkField<SecurityProfileTarget> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SecurityProfileTargetMapping.getter(SecurityProfileTargetMapping::target)).setter(SecurityProfileTargetMapping.setter(Builder::target)).constructor(SecurityProfileTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("target").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_PROFILE_IDENTIFIER_FIELD, TARGET_FIELD));
    private static final long serialVersionUID = 1L;
    private final SecurityProfileIdentifier securityProfileIdentifier;
    private final SecurityProfileTarget target;

    private SecurityProfileTargetMapping(BuilderImpl builder) {
        this.securityProfileIdentifier = builder.securityProfileIdentifier;
        this.target = builder.target;
    }

    public SecurityProfileIdentifier securityProfileIdentifier() {
        return this.securityProfileIdentifier;
    }

    public SecurityProfileTarget target() {
        return this.target;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityProfileTargetMapping)) {
            return false;
        }
        SecurityProfileTargetMapping other = (SecurityProfileTargetMapping)obj;
        return Objects.equals(this.securityProfileIdentifier(), other.securityProfileIdentifier()) && Objects.equals(this.target(), other.target());
    }

    public String toString() {
        return ToString.builder((String)"SecurityProfileTargetMapping").add("SecurityProfileIdentifier", (Object)this.securityProfileIdentifier()).add("Target", (Object)this.target()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "securityProfileIdentifier": {
                return Optional.ofNullable(clazz.cast(this.securityProfileIdentifier()));
            }
            case "target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecurityProfileTargetMapping, T> g) {
        return obj -> g.apply((SecurityProfileTargetMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SecurityProfileIdentifier securityProfileIdentifier;
        private SecurityProfileTarget target;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityProfileTargetMapping model) {
            this.securityProfileIdentifier(model.securityProfileIdentifier);
            this.target(model.target);
        }

        public final SecurityProfileIdentifier.Builder getSecurityProfileIdentifier() {
            return this.securityProfileIdentifier != null ? this.securityProfileIdentifier.toBuilder() : null;
        }

        @Override
        public final Builder securityProfileIdentifier(SecurityProfileIdentifier securityProfileIdentifier) {
            this.securityProfileIdentifier = securityProfileIdentifier;
            return this;
        }

        public final void setSecurityProfileIdentifier(SecurityProfileIdentifier.BuilderImpl securityProfileIdentifier) {
            this.securityProfileIdentifier = securityProfileIdentifier != null ? securityProfileIdentifier.build() : null;
        }

        public final SecurityProfileTarget.Builder getTarget() {
            return this.target != null ? this.target.toBuilder() : null;
        }

        @Override
        public final Builder target(SecurityProfileTarget target) {
            this.target = target;
            return this;
        }

        public final void setTarget(SecurityProfileTarget.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        public SecurityProfileTargetMapping build() {
            return new SecurityProfileTargetMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecurityProfileTargetMapping> {
        public Builder securityProfileIdentifier(SecurityProfileIdentifier var1);

        default public Builder securityProfileIdentifier(Consumer<SecurityProfileIdentifier.Builder> securityProfileIdentifier) {
            return this.securityProfileIdentifier((SecurityProfileIdentifier)((SecurityProfileIdentifier.Builder)SecurityProfileIdentifier.builder().applyMutation(securityProfileIdentifier)).build());
        }

        public Builder target(SecurityProfileTarget var1);

        default public Builder target(Consumer<SecurityProfileTarget.Builder> target) {
            return this.target((SecurityProfileTarget)((SecurityProfileTarget.Builder)SecurityProfileTarget.builder().applyMutation(target)).build());
        }
    }
}

