/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.AutoRegistrationStatus;
import software.amazon.awssdk.services.iot.model.CACertificateStatus;
import software.amazon.awssdk.services.iot.model.CertificateValidity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CACertificateDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CACertificateDescription> {
    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CACertificateDescription.getter(CACertificateDescription::certificateArn)).setter(CACertificateDescription.setter(Builder::certificateArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()}).build();
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CACertificateDescription.getter(CACertificateDescription::certificateId)).setter(CACertificateDescription.setter(Builder::certificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CACertificateDescription.getter(CACertificateDescription::statusAsString)).setter(CACertificateDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> CERTIFICATE_PEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CACertificateDescription.getter(CACertificateDescription::certificatePem)).setter(CACertificateDescription.setter(Builder::certificatePem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificatePem").build()}).build();
    private static final SdkField<String> OWNED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CACertificateDescription.getter(CACertificateDescription::ownedBy)).setter(CACertificateDescription.setter(Builder::ownedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownedBy").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CACertificateDescription.getter(CACertificateDescription::creationDate)).setter(CACertificateDescription.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<String> AUTO_REGISTRATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CACertificateDescription.getter(CACertificateDescription::autoRegistrationStatusAsString)).setter(CACertificateDescription.setter(Builder::autoRegistrationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRegistrationStatus").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CACertificateDescription.getter(CACertificateDescription::lastModifiedDate)).setter(CACertificateDescription.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final SdkField<Integer> CUSTOMER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CACertificateDescription.getter(CACertificateDescription::customerVersion)).setter(CACertificateDescription.setter(Builder::customerVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerVersion").build()}).build();
    private static final SdkField<String> GENERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CACertificateDescription.getter(CACertificateDescription::generationId)).setter(CACertificateDescription.setter(Builder::generationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationId").build()}).build();
    private static final SdkField<CertificateValidity> VALIDITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CACertificateDescription.getter(CACertificateDescription::validity)).setter(CACertificateDescription.setter(Builder::validity)).constructor(CertificateValidity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ARN_FIELD, CERTIFICATE_ID_FIELD, STATUS_FIELD, CERTIFICATE_PEM_FIELD, OWNED_BY_FIELD, CREATION_DATE_FIELD, AUTO_REGISTRATION_STATUS_FIELD, LAST_MODIFIED_DATE_FIELD, CUSTOMER_VERSION_FIELD, GENERATION_ID_FIELD, VALIDITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String certificateArn;
    private final String certificateId;
    private final String status;
    private final String certificatePem;
    private final String ownedBy;
    private final Instant creationDate;
    private final String autoRegistrationStatus;
    private final Instant lastModifiedDate;
    private final Integer customerVersion;
    private final String generationId;
    private final CertificateValidity validity;

    private CACertificateDescription(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificateId = builder.certificateId;
        this.status = builder.status;
        this.certificatePem = builder.certificatePem;
        this.ownedBy = builder.ownedBy;
        this.creationDate = builder.creationDate;
        this.autoRegistrationStatus = builder.autoRegistrationStatus;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.customerVersion = builder.customerVersion;
        this.generationId = builder.generationId;
        this.validity = builder.validity;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public String certificateId() {
        return this.certificateId;
    }

    public CACertificateStatus status() {
        return CACertificateStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String certificatePem() {
        return this.certificatePem;
    }

    public String ownedBy() {
        return this.ownedBy;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public AutoRegistrationStatus autoRegistrationStatus() {
        return AutoRegistrationStatus.fromValue(this.autoRegistrationStatus);
    }

    public String autoRegistrationStatusAsString() {
        return this.autoRegistrationStatus;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Integer customerVersion() {
        return this.customerVersion;
    }

    public String generationId() {
        return this.generationId;
    }

    public CertificateValidity validity() {
        return this.validity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRegistrationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.validity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CACertificateDescription)) {
            return false;
        }
        CACertificateDescription other = (CACertificateDescription)obj;
        return Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.certificateId(), other.certificateId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.certificatePem(), other.certificatePem()) && Objects.equals(this.ownedBy(), other.ownedBy()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.autoRegistrationStatusAsString(), other.autoRegistrationStatusAsString()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(this.customerVersion(), other.customerVersion()) && Objects.equals(this.generationId(), other.generationId()) && Objects.equals(this.validity(), other.validity());
    }

    public String toString() {
        return ToString.builder((String)"CACertificateDescription").add("CertificateArn", (Object)this.certificateArn()).add("CertificateId", (Object)this.certificateId()).add("Status", (Object)this.statusAsString()).add("CertificatePem", (Object)this.certificatePem()).add("OwnedBy", (Object)this.ownedBy()).add("CreationDate", (Object)this.creationDate()).add("AutoRegistrationStatus", (Object)this.autoRegistrationStatusAsString()).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("CustomerVersion", (Object)this.customerVersion()).add("GenerationId", (Object)this.generationId()).add("Validity", (Object)this.validity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "certificateId": {
                return Optional.ofNullable(clazz.cast(this.certificateId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "certificatePem": {
                return Optional.ofNullable(clazz.cast(this.certificatePem()));
            }
            case "ownedBy": {
                return Optional.ofNullable(clazz.cast(this.ownedBy()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "autoRegistrationStatus": {
                return Optional.ofNullable(clazz.cast(this.autoRegistrationStatusAsString()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "customerVersion": {
                return Optional.ofNullable(clazz.cast(this.customerVersion()));
            }
            case "generationId": {
                return Optional.ofNullable(clazz.cast(this.generationId()));
            }
            case "validity": {
                return Optional.ofNullable(clazz.cast(this.validity()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CACertificateDescription, T> g) {
        return obj -> g.apply((CACertificateDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateArn;
        private String certificateId;
        private String status;
        private String certificatePem;
        private String ownedBy;
        private Instant creationDate;
        private String autoRegistrationStatus;
        private Instant lastModifiedDate;
        private Integer customerVersion;
        private String generationId;
        private CertificateValidity validity;

        private BuilderImpl() {
        }

        private BuilderImpl(CACertificateDescription model) {
            this.certificateArn(model.certificateArn);
            this.certificateId(model.certificateId);
            this.status(model.status);
            this.certificatePem(model.certificatePem);
            this.ownedBy(model.ownedBy);
            this.creationDate(model.creationDate);
            this.autoRegistrationStatus(model.autoRegistrationStatus);
            this.lastModifiedDate(model.lastModifiedDate);
            this.customerVersion(model.customerVersion);
            this.generationId(model.generationId);
            this.validity(model.validity);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CACertificateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCertificatePem() {
            return this.certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        public final String getOwnedBy() {
            return this.ownedBy;
        }

        @Override
        public final Builder ownedBy(String ownedBy) {
            this.ownedBy = ownedBy;
            return this;
        }

        public final void setOwnedBy(String ownedBy) {
            this.ownedBy = ownedBy;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final String getAutoRegistrationStatus() {
            return this.autoRegistrationStatus;
        }

        @Override
        public final Builder autoRegistrationStatus(String autoRegistrationStatus) {
            this.autoRegistrationStatus = autoRegistrationStatus;
            return this;
        }

        @Override
        public final Builder autoRegistrationStatus(AutoRegistrationStatus autoRegistrationStatus) {
            this.autoRegistrationStatus(autoRegistrationStatus == null ? null : autoRegistrationStatus.toString());
            return this;
        }

        public final void setAutoRegistrationStatus(String autoRegistrationStatus) {
            this.autoRegistrationStatus = autoRegistrationStatus;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final Integer getCustomerVersion() {
            return this.customerVersion;
        }

        @Override
        public final Builder customerVersion(Integer customerVersion) {
            this.customerVersion = customerVersion;
            return this;
        }

        public final void setCustomerVersion(Integer customerVersion) {
            this.customerVersion = customerVersion;
        }

        public final String getGenerationId() {
            return this.generationId;
        }

        @Override
        public final Builder generationId(String generationId) {
            this.generationId = generationId;
            return this;
        }

        public final void setGenerationId(String generationId) {
            this.generationId = generationId;
        }

        public final CertificateValidity.Builder getValidity() {
            return this.validity != null ? this.validity.toBuilder() : null;
        }

        @Override
        public final Builder validity(CertificateValidity validity) {
            this.validity = validity;
            return this;
        }

        public final void setValidity(CertificateValidity.BuilderImpl validity) {
            this.validity = validity != null ? validity.build() : null;
        }

        public CACertificateDescription build() {
            return new CACertificateDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CACertificateDescription> {
        public Builder certificateArn(String var1);

        public Builder certificateId(String var1);

        public Builder status(String var1);

        public Builder status(CACertificateStatus var1);

        public Builder certificatePem(String var1);

        public Builder ownedBy(String var1);

        public Builder creationDate(Instant var1);

        public Builder autoRegistrationStatus(String var1);

        public Builder autoRegistrationStatus(AutoRegistrationStatus var1);

        public Builder lastModifiedDate(Instant var1);

        public Builder customerVersion(Integer var1);

        public Builder generationId(String var1);

        public Builder validity(CertificateValidity var1);

        default public Builder validity(Consumer<CertificateValidity.Builder> validity) {
            return this.validity((CertificateValidity)((CertificateValidity.Builder)CertificateValidity.builder().applyMutation(validity)).build());
        }
    }
}

