/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.DimensionValueOperator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricDimension
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricDimension> {
    private static final SdkField<String> DIMENSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MetricDimension.getter(MetricDimension::dimensionName)).setter(MetricDimension.setter(Builder::dimensionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimensionName").build()}).build();
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MetricDimension.getter(MetricDimension::operatorAsString)).setter(MetricDimension.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_NAME_FIELD, OPERATOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dimensionName;
    private final String operator;

    private MetricDimension(BuilderImpl builder) {
        this.dimensionName = builder.dimensionName;
        this.operator = builder.operator;
    }

    public String dimensionName() {
        return this.dimensionName;
    }

    public DimensionValueOperator operator() {
        return DimensionValueOperator.fromValue(this.operator);
    }

    public String operatorAsString() {
        return this.operator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDimension)) {
            return false;
        }
        MetricDimension other = (MetricDimension)obj;
        return Objects.equals(this.dimensionName(), other.dimensionName()) && Objects.equals(this.operatorAsString(), other.operatorAsString());
    }

    public String toString() {
        return ToString.builder((String)"MetricDimension").add("DimensionName", (Object)this.dimensionName()).add("Operator", (Object)this.operatorAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dimensionName": {
                return Optional.ofNullable(clazz.cast(this.dimensionName()));
            }
            case "operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricDimension, T> g) {
        return obj -> g.apply((MetricDimension)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dimensionName;
        private String operator;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDimension model) {
            this.dimensionName(model.dimensionName);
            this.operator(model.operator);
        }

        public final String getDimensionName() {
            return this.dimensionName;
        }

        @Override
        public final Builder dimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
            return this;
        }

        public final void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        public final String getOperator() {
            return this.operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(DimensionValueOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        public MetricDimension build() {
            return new MetricDimension(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricDimension> {
        public Builder dimensionName(String var1);

        public Builder operator(String var1);

        public Builder operator(DimensionValueOperator var1);
    }
}

