/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.LogLevel;
import software.amazon.awssdk.services.iot.model.LogTarget;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetV2LoggingLevelRequest
extends IotRequest
implements ToCopyableBuilder<Builder, SetV2LoggingLevelRequest> {
    private static final SdkField<LogTarget> LOG_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(SetV2LoggingLevelRequest.getter(SetV2LoggingLevelRequest::logTarget)).setter(SetV2LoggingLevelRequest.setter(Builder::logTarget)).constructor(LogTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logTarget").build()}).build();
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SetV2LoggingLevelRequest.getter(SetV2LoggingLevelRequest::logLevelAsString)).setter(SetV2LoggingLevelRequest.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_TARGET_FIELD, LOG_LEVEL_FIELD));
    private final LogTarget logTarget;
    private final String logLevel;

    private SetV2LoggingLevelRequest(BuilderImpl builder) {
        super(builder);
        this.logTarget = builder.logTarget;
        this.logLevel = builder.logLevel;
    }

    public LogTarget logTarget() {
        return this.logTarget;
    }

    public LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public String logLevelAsString() {
        return this.logLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.logTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetV2LoggingLevelRequest)) {
            return false;
        }
        SetV2LoggingLevelRequest other = (SetV2LoggingLevelRequest)((Object)obj);
        return Objects.equals(this.logTarget(), other.logTarget()) && Objects.equals(this.logLevelAsString(), other.logLevelAsString());
    }

    public String toString() {
        return ToString.builder((String)"SetV2LoggingLevelRequest").add("LogTarget", (Object)this.logTarget()).add("LogLevel", (Object)this.logLevelAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "logTarget": {
                return Optional.ofNullable(clazz.cast(this.logTarget()));
            }
            case "logLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetV2LoggingLevelRequest, T> g) {
        return obj -> g.apply((SetV2LoggingLevelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private LogTarget logTarget;
        private String logLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(SetV2LoggingLevelRequest model) {
            super(model);
            this.logTarget(model.logTarget);
            this.logLevel(model.logLevel);
        }

        public final LogTarget.Builder getLogTarget() {
            return this.logTarget != null ? this.logTarget.toBuilder() : null;
        }

        @Override
        public final Builder logTarget(LogTarget logTarget) {
            this.logTarget = logTarget;
            return this;
        }

        public final void setLogTarget(LogTarget.BuilderImpl logTarget) {
            this.logTarget = logTarget != null ? logTarget.build() : null;
        }

        public final String getLogLevelAsString() {
            return this.logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetV2LoggingLevelRequest build() {
            return new SetV2LoggingLevelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetV2LoggingLevelRequest> {
        public Builder logTarget(LogTarget var1);

        default public Builder logTarget(Consumer<LogTarget.Builder> logTarget) {
            return this.logTarget((LogTarget)((LogTarget.Builder)LogTarget.builder().applyMutation(logTarget)).build());
        }

        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

