/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the targets to which audit notifications are sent.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuditNotificationTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<AuditNotificationTarget.Builder, AuditNotificationTarget> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuditNotificationTarget::targetArn)).setter(setter(Builder::targetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuditNotificationTarget::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AuditNotificationTarget::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD,
            ROLE_ARN_FIELD, ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String targetArn;

    private final String roleArn;

    private final Boolean enabled;

    private AuditNotificationTarget(BuilderImpl builder) {
        this.targetArn = builder.targetArn;
        this.roleArn = builder.roleArn;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * The ARN of the target (SNS topic) to which audit notifications are sent.
     * </p>
     * 
     * @return The ARN of the target (SNS topic) to which audit notifications are sent.
     */
    public String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The ARN of the role that grants permission to send notifications to the target.
     * </p>
     * 
     * @return The ARN of the role that grants permission to send notifications to the target.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * True if notifications to the target are enabled.
     * </p>
     * 
     * @return True if notifications to the target are enabled.
     */
    public Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditNotificationTarget)) {
            return false;
        }
        AuditNotificationTarget other = (AuditNotificationTarget) obj;
        return Objects.equals(targetArn(), other.targetArn()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AuditNotificationTarget").add("TargetArn", targetArn()).add("RoleArn", roleArn())
                .add("Enabled", enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetArn":
            return Optional.ofNullable(clazz.cast(targetArn()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuditNotificationTarget, T> g) {
        return obj -> g.apply((AuditNotificationTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuditNotificationTarget> {
        /**
         * <p>
         * The ARN of the target (SNS topic) to which audit notifications are sent.
         * </p>
         * 
         * @param targetArn
         *        The ARN of the target (SNS topic) to which audit notifications are sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The ARN of the role that grants permission to send notifications to the target.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role that grants permission to send notifications to the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * True if notifications to the target are enabled.
         * </p>
         * 
         * @param enabled
         *        True if notifications to the target are enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl implements Builder {
        private String targetArn;

        private String roleArn;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditNotificationTarget model) {
            targetArn(model.targetArn);
            roleArn(model.roleArn);
            enabled(model.enabled);
        }

        public final String getTargetArn() {
            return targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public AuditNotificationTarget build() {
            return new AuditNotificationTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
