/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestAuthorizationResponse extends IotResponse implements
        ToCopyableBuilder<TestAuthorizationResponse.Builder, TestAuthorizationResponse> {
    private static final SdkField<List<AuthResult>> AUTH_RESULTS_FIELD = SdkField
            .<List<AuthResult>> builder(MarshallingType.LIST)
            .getter(getter(TestAuthorizationResponse::authResults))
            .setter(setter(Builder::authResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuthResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuthResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_RESULTS_FIELD));

    private final List<AuthResult> authResults;

    private TestAuthorizationResponse(BuilderImpl builder) {
        super(builder);
        this.authResults = builder.authResults;
    }

    /**
     * Returns true if the AuthResults property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAuthResults() {
        return authResults != null && !(authResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The authentication results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAuthResults()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The authentication results.
     */
    public List<AuthResult> authResults() {
        return authResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(authResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestAuthorizationResponse)) {
            return false;
        }
        TestAuthorizationResponse other = (TestAuthorizationResponse) obj;
        return Objects.equals(authResults(), other.authResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TestAuthorizationResponse").add("AuthResults", authResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authResults":
            return Optional.ofNullable(clazz.cast(authResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestAuthorizationResponse, T> g) {
        return obj -> g.apply((TestAuthorizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, TestAuthorizationResponse> {
        /**
         * <p>
         * The authentication results.
         * </p>
         * 
         * @param authResults
         *        The authentication results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authResults(Collection<AuthResult> authResults);

        /**
         * <p>
         * The authentication results.
         * </p>
         * 
         * @param authResults
         *        The authentication results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authResults(AuthResult... authResults);

        /**
         * <p>
         * The authentication results.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AuthResult>.Builder} avoiding the need to
         * create one manually via {@link List<AuthResult>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AuthResult>.Builder#build()} is called immediately and its
         * result is passed to {@link #authResults(List<AuthResult>)}.
         * 
         * @param authResults
         *        a consumer that will call methods on {@link List<AuthResult>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authResults(List<AuthResult>)
         */
        Builder authResults(Consumer<AuthResult.Builder>... authResults);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<AuthResult> authResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestAuthorizationResponse model) {
            super(model);
            authResults(model.authResults);
        }

        public final Collection<AuthResult.Builder> getAuthResults() {
            return authResults != null ? authResults.stream().map(AuthResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder authResults(Collection<AuthResult> authResults) {
            this.authResults = AuthResultsCopier.copy(authResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authResults(AuthResult... authResults) {
            authResults(Arrays.asList(authResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authResults(Consumer<AuthResult.Builder>... authResults) {
            authResults(Stream.of(authResults).map(c -> AuthResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAuthResults(Collection<AuthResult.BuilderImpl> authResults) {
            this.authResults = AuthResultsCopier.copyFromBuilder(authResults);
        }

        @Override
        public TestAuthorizationResponse build() {
            return new TestAuthorizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
