/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAuditFindingsResponse extends IotResponse implements
        ToCopyableBuilder<ListAuditFindingsResponse.Builder, ListAuditFindingsResponse> {
    private static final SdkField<List<AuditFinding>> FINDINGS_FIELD = SdkField
            .<List<AuditFinding>> builder(MarshallingType.LIST)
            .getter(getter(ListAuditFindingsResponse::findings))
            .setter(setter(Builder::findings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AuditFinding> builder(MarshallingType.SDK_POJO)
                                            .constructor(AuditFinding::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAuditFindingsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDINGS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AuditFinding> findings;

    private final String nextToken;

    private ListAuditFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.findings = builder.findings;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Findings property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFindings() {
        return findings != null && !(findings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The findings (results) of the audit.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFindings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The findings (results) of the audit.
     */
    public List<AuditFinding> findings() {
        return findings;
    }

    /**
     * <p>
     * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
     * results.
     * </p>
     * 
     * @return A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
     *         additional results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(findings());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuditFindingsResponse)) {
            return false;
        }
        ListAuditFindingsResponse other = (ListAuditFindingsResponse) obj;
        return Objects.equals(findings(), other.findings()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListAuditFindingsResponse").add("Findings", findings()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "findings":
            return Optional.ofNullable(clazz.cast(findings()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAuditFindingsResponse, T> g) {
        return obj -> g.apply((ListAuditFindingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAuditFindingsResponse> {
        /**
         * <p>
         * The findings (results) of the audit.
         * </p>
         * 
         * @param findings
         *        The findings (results) of the audit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findings(Collection<AuditFinding> findings);

        /**
         * <p>
         * The findings (results) of the audit.
         * </p>
         * 
         * @param findings
         *        The findings (results) of the audit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findings(AuditFinding... findings);

        /**
         * <p>
         * The findings (results) of the audit.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AuditFinding>.Builder} avoiding the need to
         * create one manually via {@link List<AuditFinding>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AuditFinding>.Builder#build()} is called immediately and its
         * result is passed to {@link #findings(List<AuditFinding>)}.
         * 
         * @param findings
         *        a consumer that will call methods on {@link List<AuditFinding>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findings(List<AuditFinding>)
         */
        Builder findings(Consumer<AuditFinding.Builder>... findings);

        /**
         * <p>
         * A token that can be used to retrieve the next set of results, or <code>null</code> if there are no additional
         * results.
         * </p>
         * 
         * @param nextToken
         *        A token that can be used to retrieve the next set of results, or <code>null</code> if there are no
         *        additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<AuditFinding> findings = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuditFindingsResponse model) {
            super(model);
            findings(model.findings);
            nextToken(model.nextToken);
        }

        public final Collection<AuditFinding.Builder> getFindings() {
            return findings != null ? findings.stream().map(AuditFinding::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder findings(Collection<AuditFinding> findings) {
            this.findings = AuditFindingsCopier.copy(findings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(AuditFinding... findings) {
            findings(Arrays.asList(findings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findings(Consumer<AuditFinding.Builder>... findings) {
            findings(Stream.of(findings).map(c -> AuditFinding.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFindings(Collection<AuditFinding.BuilderImpl> findings) {
            this.findings = AuditFindingsCopier.copyFromBuilder(findings);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAuditFindingsResponse build() {
            return new ListAuditFindingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
