/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.services.iot.model.TopicRuleDestinationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTopicRuleDestinationRequest
extends IotRequest
implements ToCopyableBuilder<Builder, CreateTopicRuleDestinationRequest> {
    private static final SdkField<TopicRuleDestinationConfiguration> DESTINATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateTopicRuleDestinationRequest.getter(CreateTopicRuleDestinationRequest::destinationConfiguration)).setter(CreateTopicRuleDestinationRequest.setter(Builder::destinationConfiguration)).constructor(TopicRuleDestinationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_CONFIGURATION_FIELD));
    private final TopicRuleDestinationConfiguration destinationConfiguration;

    private CreateTopicRuleDestinationRequest(BuilderImpl builder) {
        super(builder);
        this.destinationConfiguration = builder.destinationConfiguration;
    }

    public TopicRuleDestinationConfiguration destinationConfiguration() {
        return this.destinationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTopicRuleDestinationRequest)) {
            return false;
        }
        CreateTopicRuleDestinationRequest other = (CreateTopicRuleDestinationRequest)((Object)obj);
        return Objects.equals(this.destinationConfiguration(), other.destinationConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"CreateTopicRuleDestinationRequest").add("DestinationConfiguration", (Object)this.destinationConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "destinationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.destinationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTopicRuleDestinationRequest, T> g) {
        return obj -> g.apply((CreateTopicRuleDestinationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private TopicRuleDestinationConfiguration destinationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTopicRuleDestinationRequest model) {
            super(model);
            this.destinationConfiguration(model.destinationConfiguration);
        }

        public final TopicRuleDestinationConfiguration.Builder getDestinationConfiguration() {
            return this.destinationConfiguration != null ? this.destinationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder destinationConfiguration(TopicRuleDestinationConfiguration destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration;
            return this;
        }

        public final void setDestinationConfiguration(TopicRuleDestinationConfiguration.BuilderImpl destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration != null ? destinationConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTopicRuleDestinationRequest build() {
            return new CreateTopicRuleDestinationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTopicRuleDestinationRequest> {
        public Builder destinationConfiguration(TopicRuleDestinationConfiguration var1);

        default public Builder destinationConfiguration(Consumer<TopicRuleDestinationConfiguration.Builder> destinationConfiguration) {
            return this.destinationConfiguration((TopicRuleDestinationConfiguration)((TopicRuleDestinationConfiguration.Builder)TopicRuleDestinationConfiguration.builder().applyMutation(destinationConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

