/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.KeyPair;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProvisioningClaimResponse
extends IotResponse
implements ToCopyableBuilder<Builder, CreateProvisioningClaimResponse> {
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateProvisioningClaimResponse.getter(CreateProvisioningClaimResponse::certificateId)).setter(CreateProvisioningClaimResponse.setter(Builder::certificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateId").build()}).build();
    private static final SdkField<String> CERTIFICATE_PEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateProvisioningClaimResponse.getter(CreateProvisioningClaimResponse::certificatePem)).setter(CreateProvisioningClaimResponse.setter(Builder::certificatePem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificatePem").build()}).build();
    private static final SdkField<KeyPair> KEY_PAIR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateProvisioningClaimResponse.getter(CreateProvisioningClaimResponse::keyPair)).setter(CreateProvisioningClaimResponse.setter(Builder::keyPair)).constructor(KeyPair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyPair").build()}).build();
    private static final SdkField<Instant> EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(CreateProvisioningClaimResponse.getter(CreateProvisioningClaimResponse::expiration)).setter(CreateProvisioningClaimResponse.setter(Builder::expiration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ID_FIELD, CERTIFICATE_PEM_FIELD, KEY_PAIR_FIELD, EXPIRATION_FIELD));
    private final String certificateId;
    private final String certificatePem;
    private final KeyPair keyPair;
    private final Instant expiration;

    private CreateProvisioningClaimResponse(BuilderImpl builder) {
        super(builder);
        this.certificateId = builder.certificateId;
        this.certificatePem = builder.certificatePem;
        this.keyPair = builder.keyPair;
        this.expiration = builder.expiration;
    }

    public String certificateId() {
        return this.certificateId;
    }

    public String certificatePem() {
        return this.certificatePem;
    }

    public KeyPair keyPair() {
        return this.keyPair;
    }

    public Instant expiration() {
        return this.expiration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPair());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProvisioningClaimResponse)) {
            return false;
        }
        CreateProvisioningClaimResponse other = (CreateProvisioningClaimResponse)((Object)obj);
        return Objects.equals(this.certificateId(), other.certificateId()) && Objects.equals(this.certificatePem(), other.certificatePem()) && Objects.equals(this.keyPair(), other.keyPair()) && Objects.equals(this.expiration(), other.expiration());
    }

    public String toString() {
        return ToString.builder((String)"CreateProvisioningClaimResponse").add("CertificateId", (Object)this.certificateId()).add("CertificatePem", (Object)this.certificatePem()).add("KeyPair", (Object)this.keyPair()).add("Expiration", (Object)this.expiration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateId": {
                return Optional.ofNullable(clazz.cast(this.certificateId()));
            }
            case "certificatePem": {
                return Optional.ofNullable(clazz.cast(this.certificatePem()));
            }
            case "keyPair": {
                return Optional.ofNullable(clazz.cast(this.keyPair()));
            }
            case "expiration": {
                return Optional.ofNullable(clazz.cast(this.expiration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateProvisioningClaimResponse, T> g) {
        return obj -> g.apply((CreateProvisioningClaimResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String certificateId;
        private String certificatePem;
        private KeyPair keyPair;
        private Instant expiration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProvisioningClaimResponse model) {
            super(model);
            this.certificateId(model.certificateId);
            this.certificatePem(model.certificatePem);
            this.keyPair(model.keyPair);
            this.expiration(model.expiration);
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getCertificatePem() {
            return this.certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        public final KeyPair.Builder getKeyPair() {
            return this.keyPair != null ? this.keyPair.toBuilder() : null;
        }

        @Override
        public final Builder keyPair(KeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public final void setKeyPair(KeyPair.BuilderImpl keyPair) {
            this.keyPair = keyPair != null ? keyPair.build() : null;
        }

        public final Instant getExpiration() {
            return this.expiration;
        }

        @Override
        public final Builder expiration(Instant expiration) {
            this.expiration = expiration;
            return this;
        }

        public final void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }

        @Override
        public CreateProvisioningClaimResponse build() {
            return new CreateProvisioningClaimResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProvisioningClaimResponse> {
        public Builder certificateId(String var1);

        public Builder certificatePem(String var1);

        public Builder keyPair(KeyPair var1);

        default public Builder keyPair(Consumer<KeyPair.Builder> keyPair) {
            return this.keyPair((KeyPair)((KeyPair.Builder)KeyPair.builder().applyMutation(keyPair)).build());
        }

        public Builder expiration(Instant var1);
    }
}

