/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iot.model.TopicRule;
import software.amazon.awssdk.services.iot.transform.ActionUnmarshaller;

public class TopicRuleUnmarshaller
implements Unmarshaller<TopicRule, JsonUnmarshallerContext> {
    private static final TopicRuleUnmarshaller INSTANCE = new TopicRuleUnmarshaller();

    public TopicRule unmarshall(JsonUnmarshallerContext context) throws Exception {
        TopicRule.Builder topicRuleBuilder = TopicRule.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ruleName", targetDepth)) {
                    context.nextToken();
                    topicRuleBuilder.ruleName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("sql", targetDepth)) {
                    context.nextToken();
                    topicRuleBuilder.sql((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("description", targetDepth)) {
                    context.nextToken();
                    topicRuleBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("createdAt", targetDepth)) {
                    context.nextToken();
                    topicRuleBuilder.createdAt((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("actions", targetDepth)) {
                    context.nextToken();
                    topicRuleBuilder.actions(new ListUnmarshaller((Unmarshaller)ActionUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("ruleDisabled", targetDepth)) {
                    context.nextToken();
                    topicRuleBuilder.ruleDisabled((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("awsIotSqlVersion", targetDepth)) {
                    context.nextToken();
                    topicRuleBuilder.awsIotSqlVersion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("errorAction", targetDepth)) {
                    context.nextToken();
                    topicRuleBuilder.errorAction(ActionUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (TopicRule)topicRuleBuilder.build();
    }

    public static TopicRuleUnmarshaller getInstance() {
        return INSTANCE;
    }
}

