/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.ThingGroupProperties;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ThingGroupPropertiesMarshaller {
    private static final MarshallingInfo<String> THINGGROUPDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("thingGroupDescription").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ATTRIBUTEPAYLOAD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attributePayload").isBinary(false).build();
    private static final ThingGroupPropertiesMarshaller INSTANCE = new ThingGroupPropertiesMarshaller();

    private ThingGroupPropertiesMarshaller() {
    }

    public static ThingGroupPropertiesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ThingGroupProperties thingGroupProperties, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)thingGroupProperties, (String)"thingGroupProperties");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)thingGroupProperties.thingGroupDescription(), THINGGROUPDESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)thingGroupProperties.attributePayload(), ATTRIBUTEPAYLOAD_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

