/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.TestAuthorizationRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TestAuthorizationRequestModelMarshaller {
    private static final MarshallingInfo<String> PRINCIPAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("principal").isBinary(false).build();
    private static final MarshallingInfo<String> COGNITOIDENTITYPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cognitoIdentityPoolId").isBinary(false).build();
    private static final MarshallingInfo<List> AUTHINFOS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("authInfos").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("clientId").isBinary(false).build();
    private static final MarshallingInfo<List> POLICYNAMESTOADD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("policyNamesToAdd").isBinary(false).build();
    private static final MarshallingInfo<List> POLICYNAMESTOSKIP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("policyNamesToSkip").isBinary(false).build();
    private static final TestAuthorizationRequestModelMarshaller INSTANCE = new TestAuthorizationRequestModelMarshaller();

    private TestAuthorizationRequestModelMarshaller() {
    }

    public static TestAuthorizationRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TestAuthorizationRequest testAuthorizationRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)testAuthorizationRequest), (String)"testAuthorizationRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)testAuthorizationRequest.principal(), PRINCIPAL_BINDING);
            protocolMarshaller.marshall((Object)testAuthorizationRequest.cognitoIdentityPoolId(), COGNITOIDENTITYPOOLID_BINDING);
            protocolMarshaller.marshall(testAuthorizationRequest.authInfos(), AUTHINFOS_BINDING);
            protocolMarshaller.marshall((Object)testAuthorizationRequest.clientId(), CLIENTID_BINDING);
            protocolMarshaller.marshall(testAuthorizationRequest.policyNamesToAdd(), POLICYNAMESTOADD_BINDING);
            protocolMarshaller.marshall(testAuthorizationRequest.policyNamesToSkip(), POLICYNAMESTOSKIP_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

