/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.TaskStatistics;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TaskStatisticsMarshaller {
    private static final MarshallingInfo<Integer> TOTALCHECKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("totalChecks").isBinary(false).build();
    private static final MarshallingInfo<Integer> INPROGRESSCHECKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("inProgressChecks").isBinary(false).build();
    private static final MarshallingInfo<Integer> WAITINGFORDATACOLLECTIONCHECKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("waitingForDataCollectionChecks").isBinary(false).build();
    private static final MarshallingInfo<Integer> COMPLIANTCHECKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("compliantChecks").isBinary(false).build();
    private static final MarshallingInfo<Integer> NONCOMPLIANTCHECKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nonCompliantChecks").isBinary(false).build();
    private static final MarshallingInfo<Integer> FAILEDCHECKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("failedChecks").isBinary(false).build();
    private static final MarshallingInfo<Integer> CANCELEDCHECKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("canceledChecks").isBinary(false).build();
    private static final TaskStatisticsMarshaller INSTANCE = new TaskStatisticsMarshaller();

    private TaskStatisticsMarshaller() {
    }

    public static TaskStatisticsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TaskStatistics taskStatistics, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)taskStatistics, (String)"taskStatistics");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)taskStatistics.totalChecks(), TOTALCHECKS_BINDING);
            protocolMarshaller.marshall((Object)taskStatistics.inProgressChecks(), INPROGRESSCHECKS_BINDING);
            protocolMarshaller.marshall((Object)taskStatistics.waitingForDataCollectionChecks(), WAITINGFORDATACOLLECTIONCHECKS_BINDING);
            protocolMarshaller.marshall((Object)taskStatistics.compliantChecks(), COMPLIANTCHECKS_BINDING);
            protocolMarshaller.marshall((Object)taskStatistics.nonCompliantChecks(), NONCOMPLIANTCHECKS_BINDING);
            protocolMarshaller.marshall((Object)taskStatistics.failedChecks(), FAILEDCHECKS_BINDING);
            protocolMarshaller.marshall((Object)taskStatistics.canceledChecks(), CANCELEDCHECKS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

