/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.Stream;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StreamMarshaller {
    private static final MarshallingInfo<String> STREAMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamId").isBinary(false).build();
    private static final MarshallingInfo<Integer> FILEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileId").isBinary(false).build();
    private static final StreamMarshaller INSTANCE = new StreamMarshaller();

    private StreamMarshaller() {
    }

    public static StreamMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Stream stream, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)stream, (String)"stream");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)stream.streamId(), STREAMID_BINDING);
            protocolMarshaller.marshall((Object)stream.fileId(), FILEID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

