/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.SecurityProfileTargetMapping;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SecurityProfileTargetMappingMarshaller {
    private static final MarshallingInfo<StructuredPojo> SECURITYPROFILEIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("securityProfileIdentifier").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TARGET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("target").isBinary(false).build();
    private static final SecurityProfileTargetMappingMarshaller INSTANCE = new SecurityProfileTargetMappingMarshaller();

    private SecurityProfileTargetMappingMarshaller() {
    }

    public static SecurityProfileTargetMappingMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SecurityProfileTargetMapping securityProfileTargetMapping, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)securityProfileTargetMapping, (String)"securityProfileTargetMapping");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)securityProfileTargetMapping.securityProfileIdentifier(), SECURITYPROFILEIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)securityProfileTargetMapping.target(), TARGET_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

