/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.ResourceIdentifier;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResourceIdentifierMarshaller {
    private static final MarshallingInfo<String> DEVICECERTIFICATEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deviceCertificateId").isBinary(false).build();
    private static final MarshallingInfo<String> CACERTIFICATEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("caCertificateId").isBinary(false).build();
    private static final MarshallingInfo<String> COGNITOIDENTITYPOOLID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cognitoIdentityPoolId").isBinary(false).build();
    private static final MarshallingInfo<String> CLIENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("clientId").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> POLICYVERSIONIDENTIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("policyVersionIdentifier").isBinary(false).build();
    private static final MarshallingInfo<String> ACCOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("account").isBinary(false).build();
    private static final ResourceIdentifierMarshaller INSTANCE = new ResourceIdentifierMarshaller();

    private ResourceIdentifierMarshaller() {
    }

    public static ResourceIdentifierMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceIdentifier resourceIdentifier, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resourceIdentifier, (String)"resourceIdentifier");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)resourceIdentifier.deviceCertificateId(), DEVICECERTIFICATEID_BINDING);
            protocolMarshaller.marshall((Object)resourceIdentifier.caCertificateId(), CACERTIFICATEID_BINDING);
            protocolMarshaller.marshall((Object)resourceIdentifier.cognitoIdentityPoolId(), COGNITOIDENTITYPOOLID_BINDING);
            protocolMarshaller.marshall((Object)resourceIdentifier.clientId(), CLIENTID_BINDING);
            protocolMarshaller.marshall((Object)resourceIdentifier.policyVersionIdentifier(), POLICYVERSIONIDENTIFIER_BINDING);
            protocolMarshaller.marshall((Object)resourceIdentifier.account(), ACCOUNT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

