/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.RegistrationConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RegistrationConfigMarshaller {
    private static final MarshallingInfo<String> TEMPLATEBODY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("templateBody").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final RegistrationConfigMarshaller INSTANCE = new RegistrationConfigMarshaller();

    private RegistrationConfigMarshaller() {
    }

    public static RegistrationConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RegistrationConfig registrationConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)registrationConfig, (String)"registrationConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)registrationConfig.templateBody(), TEMPLATEBODY_BINDING);
            protocolMarshaller.marshall((Object)registrationConfig.roleArn(), ROLEARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

