/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.MapUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iot.model.NonCompliantResource;
import software.amazon.awssdk.services.iot.transform.ResourceIdentifierUnmarshaller;

public class NonCompliantResourceUnmarshaller
implements Unmarshaller<NonCompliantResource, JsonUnmarshallerContext> {
    private static final NonCompliantResourceUnmarshaller INSTANCE = new NonCompliantResourceUnmarshaller();

    public NonCompliantResource unmarshall(JsonUnmarshallerContext context) throws Exception {
        NonCompliantResource.Builder nonCompliantResourceBuilder = NonCompliantResource.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("resourceType", targetDepth)) {
                    context.nextToken();
                    nonCompliantResourceBuilder.resourceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("resourceIdentifier", targetDepth)) {
                    context.nextToken();
                    nonCompliantResourceBuilder.resourceIdentifier(ResourceIdentifierUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("additionalInfo", targetDepth)) {
                    context.nextToken();
                    nonCompliantResourceBuilder.additionalInfo(new MapUnmarshaller(context.getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (NonCompliantResource)nonCompliantResourceBuilder.build();
    }

    public static NonCompliantResourceUnmarshaller getInstance() {
        return INSTANCE;
    }
}

