/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.MetricValue;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MetricValueMarshaller {
    private static final MarshallingInfo<Long> COUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("count").isBinary(false).build();
    private static final MarshallingInfo<List> CIDRS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cidrs").isBinary(false).build();
    private static final MarshallingInfo<List> PORTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ports").isBinary(false).build();
    private static final MetricValueMarshaller INSTANCE = new MetricValueMarshaller();

    private MetricValueMarshaller() {
    }

    public static MetricValueMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MetricValue metricValue, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)metricValue, (String)"metricValue");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)metricValue.count(), COUNT_BINDING);
            protocolMarshaller.marshall(metricValue.cidrs(), CIDRS_BINDING);
            protocolMarshaller.marshall(metricValue.ports(), PORTS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

