/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iot.model.LogTarget;

public class LogTargetUnmarshaller
implements Unmarshaller<LogTarget, JsonUnmarshallerContext> {
    private static final LogTargetUnmarshaller INSTANCE = new LogTargetUnmarshaller();

    public LogTarget unmarshall(JsonUnmarshallerContext context) throws Exception {
        LogTarget.Builder logTargetBuilder = LogTarget.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("targetType", targetDepth)) {
                    context.nextToken();
                    logTargetBuilder.targetType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("targetName", targetDepth)) {
                    context.nextToken();
                    logTargetBuilder.targetName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (LogTarget)logTargetBuilder.build();
    }

    public static LogTargetUnmarshaller getInstance() {
        return INSTANCE;
    }
}

