/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.LogTarget;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LogTargetMarshaller {
    private static final MarshallingInfo<String> TARGETTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetType").isBinary(false).build();
    private static final MarshallingInfo<String> TARGETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetName").isBinary(false).build();
    private static final LogTargetMarshaller INSTANCE = new LogTargetMarshaller();

    private LogTargetMarshaller() {
    }

    public static LogTargetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LogTarget logTarget, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)logTarget, (String)"logTarget");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)logTarget.targetTypeAsString(), TARGETTYPE_BINDING);
            protocolMarshaller.marshall((Object)logTarget.targetName(), TARGETNAME_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

