/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.LogTargetConfiguration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LogTargetConfigurationMarshaller {
    private static final MarshallingInfo<StructuredPojo> LOGTARGET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logTarget").isBinary(false).build();
    private static final MarshallingInfo<String> LOGLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logLevel").isBinary(false).build();
    private static final LogTargetConfigurationMarshaller INSTANCE = new LogTargetConfigurationMarshaller();

    private LogTargetConfigurationMarshaller() {
    }

    public static LogTargetConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LogTargetConfiguration logTargetConfiguration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)logTargetConfiguration, (String)"logTargetConfiguration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)logTargetConfiguration.logTarget(), LOGTARGET_BINDING);
            protocolMarshaller.marshall((Object)logTargetConfiguration.logLevelAsString(), LOGLEVEL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

