/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.LambdaAction;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LambdaActionMarshaller {
    private static final MarshallingInfo<String> FUNCTIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("functionArn").isBinary(false).build();
    private static final LambdaActionMarshaller INSTANCE = new LambdaActionMarshaller();

    private LambdaActionMarshaller() {
    }

    public static LambdaActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LambdaAction lambdaAction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)lambdaAction, (String)"lambdaAction");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)lambdaAction.functionArn(), FUNCTIONARN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

