/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.ElasticsearchAction;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ElasticsearchActionMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final MarshallingInfo<String> ENDPOINT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endpoint").isBinary(false).build();
    private static final MarshallingInfo<String> INDEX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("index").isBinary(false).build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").isBinary(false).build();
    private static final ElasticsearchActionMarshaller INSTANCE = new ElasticsearchActionMarshaller();

    private ElasticsearchActionMarshaller() {
    }

    public static ElasticsearchActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ElasticsearchAction elasticsearchAction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)elasticsearchAction, (String)"elasticsearchAction");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)elasticsearchAction.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchAction.endpoint(), ENDPOINT_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchAction.index(), INDEX_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchAction.type(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)elasticsearchAction.id(), ID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

