/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.EffectivePolicy;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EffectivePolicyMarshaller {
    private static final MarshallingInfo<String> POLICYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("policyName").isBinary(false).build();
    private static final MarshallingInfo<String> POLICYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("policyArn").isBinary(false).build();
    private static final MarshallingInfo<String> POLICYDOCUMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("policyDocument").isBinary(false).build();
    private static final EffectivePolicyMarshaller INSTANCE = new EffectivePolicyMarshaller();

    private EffectivePolicyMarshaller() {
    }

    public static EffectivePolicyMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EffectivePolicy effectivePolicy, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)effectivePolicy, (String)"effectivePolicy");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)effectivePolicy.policyName(), POLICYNAME_BINDING);
            protocolMarshaller.marshall((Object)effectivePolicy.policyArn(), POLICYARN_BINDING);
            protocolMarshaller.marshall((Object)effectivePolicy.policyDocument(), POLICYDOCUMENT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

