/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.DescribeJobExecutionRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DescribeJobExecutionRequestModelMarshaller {
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("jobId").isBinary(false).build();
    private static final MarshallingInfo<String> THINGNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("thingName").isBinary(false).build();
    private static final MarshallingInfo<Long> EXECUTIONNUMBER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("executionNumber").isBinary(false).build();
    private static final DescribeJobExecutionRequestModelMarshaller INSTANCE = new DescribeJobExecutionRequestModelMarshaller();

    private DescribeJobExecutionRequestModelMarshaller() {
    }

    public static DescribeJobExecutionRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DescribeJobExecutionRequest describeJobExecutionRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)describeJobExecutionRequest), (String)"describeJobExecutionRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)describeJobExecutionRequest.jobId(), JOBID_BINDING);
            protocolMarshaller.marshall((Object)describeJobExecutionRequest.thingName(), THINGNAME_BINDING);
            protocolMarshaller.marshall((Object)describeJobExecutionRequest.executionNumber(), EXECUTIONNUMBER_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

